/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.remote_data_acces;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import de.rtb.pcon.api.remote_data_acces.ExportedMoney;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.clearing.Clearing;
import de.rtb.pcontrol.utils.DateTimeUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;

@Schema(name="Clearing", description="Clearing message generated by PDM.")
class ExportedClearingMessageDao {
    @Schema(description="Clearing unique identification.")
    @JacksonXmlProperty(isAttribute=true)
    private Long id;
    @Schema(description="Unique identification of PDM which mediated clearing.")
    @JacksonXmlProperty(localName="pdm", isAttribute=true)
    private Integer pdmId;
    @Schema(description="Amount of money collected over time between tow consequent clearing.")
    private ExportedMoney price;
    @Schema(description="Time when event was created (got form PDM)")
    private LocalDateTime pdmTime;
    @Schema(description="Time instant when the message was recieved by server")
    private LocalDateTime recieved;
    @Schema(description="Tracer number")
    private int tracer;
    @Schema(description="Clearing number generated by PDM")
    private int clearingNr;
    @Schema(description="Clearing account number")
    private Integer accountNr;
    @Schema(description="Means of payments")
    private PaymentType type;

    public ExportedClearingMessageDao(Clearing pt, ZoneId timeZone, boolean exporMoney) {
        this.id = pt.getId();
        this.pdmId = pt.getPdm().getId();
        if (exporMoney) {
            this.price = new ExportedMoney(pt.getValueSold(), pt.getCurrency());
        }
        this.pdmTime = DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getPdmTime(), (ZoneId)timeZone);
        this.recieved = DateTimeUtils.toLocalDateTime((OffsetDateTime)pt.getServerTime(), (ZoneId)timeZone);
        this.tracer = pt.getTracer();
        this.clearingNr = pt.getClearingNumber();
        this.accountNr = pt.getAsn();
        this.type = pt.getPaymentType();
    }

    @JsonProperty(value="type")
    public String getTypeJson() {
        return this.type != null ? this.type.name() : null;
    }

    public Long getId() {
        return this.id;
    }

    public Integer getPdmId() {
        return this.pdmId;
    }

    public ExportedMoney getPrice() {
        return this.price;
    }

    public LocalDateTime getPdmTime() {
        return this.pdmTime;
    }

    public LocalDateTime getRecieved() {
        return this.recieved;
    }

    public int getTracer() {
        return this.tracer;
    }

    public int getClearingNr() {
        return this.clearingNr;
    }

    public Integer getAccountNr() {
        return this.accountNr;
    }

    public PaymentType getType() {
        return this.type;
    }
}

