/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcontrol.utils;

import de.rtb.pcon.features.bonus.AppliedBonus;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.TariffInfo;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelOutputStream
extends FilterOutputStream {
    public static final int EXCEL_ROW_LIMIT = 1000000;
    private XSSFWorkbook workbook;
    private SXSSFWorkbook sworkbook;
    private Sheet sheet;
    private Row row;
    private int rowIndex;
    private int colIndex;
    private boolean autoAddSheetes;
    private String autoSheetName;
    private int autoSheetIndex;
    private Map<String, CellStyle> styles = new HashMap();

    public ExcelOutputStream(OutputStream out, boolean autoAddSheets) {
        super(out);
        this.workbook = new XSSFWorkbook();
        this.sworkbook = new SXSSFWorkbook(this.workbook, 1, false, true);
        this.autoAddSheetes = autoAddSheets;
        this.createDefaultStyles();
    }

    @Override
    public void close() throws IOException {
        this.sworkbook.write(this.out);
        this.sworkbook.close();
        super.close();
    }

    @Override
    public void write(int b) throws IOException {
        throw new NotImplementedException("Writing of values directly to the stream is not supported! Use writeCell... methods instead.");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        throw new NotImplementedException("Writing of values directly to the stream is not supported! Use writeCell... methods instead.");
    }

    public Sheet addSheet(String name) {
        this.autoSheetName = name;
        this.autoSheetIndex = 1;
        return this.addSheetInternal(name);
    }

    private Sheet addSheetInternal(String name) {
        this.rowIndex = -1;
        this.colIndex = -1;
        this.sheet = this.sworkbook.createSheet(name);
        return this.sheet;
    }

    public Row addRow() {
        if (this.autoAddSheetes && this.rowIndex >= 999999) {
            if (this.autoSheetIndex == 1) {
                this.workbook.setSheetName(this.workbook.getSheetIndex(this.sheet.getSheetName()), this.autoSheetName + " (" + this.autoSheetIndex + ")");
            }
            ++this.autoSheetIndex;
            this.addSheetInternal(this.autoSheetName + " (" + this.autoSheetIndex + ")");
        }
        this.row = this.sheet.createRow(++this.rowIndex);
        this.colIndex = -1;
        return this.row;
    }

    public Cell addCell() {
        return this.row.createCell(++this.colIndex);
    }

    public void writeHeaderRow(String ... labels) {
        this.addRow();
        for (String label : labels) {
            Cell cell = this.addCell();
            cell.setCellValue(label);
            cell.setCellStyle((CellStyle)this.styles.get("header"));
        }
    }

    public void registerCellStyle(String name, CellStyle style) {
        this.styles.put(name, style);
    }

    public XSSFCellStyle registerDateTimeStyle(String name, String format) {
        XSSFCellStyle style = this.workbook.createCellStyle();
        XSSFCreationHelper createHelper = this.workbook.getCreationHelper();
        style.setDataFormat(createHelper.createDataFormat().getFormat(format));
        this.styles.put(name, style);
        return style;
    }

    private void createDefaultStyles() {
        XSSFCellStyle headerStyle = this.workbook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont headerFont = this.workbook.createFont();
        headerFont.setBold(true);
        headerStyle.setFont((Font)headerFont);
        this.styles.put("header", headerStyle);
    }

    public void writeEmptyCell() {
        Cell cell = this.addCell();
        cell.setBlank();
    }

    public void writeCell(Number number) {
        this.writeCell(number, null);
    }

    public void writeCell(Number number, String styleName) {
        if (number == null) {
            this.writeEmptyCell();
            return;
        }
        Cell cell = this.addCell();
        cell.setCellStyle((CellStyle)this.styles.get(styleName));
        cell.setCellValue(number.doubleValue());
    }

    public void writeCell(String text) {
        if (text == null) {
            this.writeEmptyCell();
            return;
        }
        Cell cell = this.addCell();
        cell.setCellValue(text);
    }

    public void writeCell(Duration duration, String styleName) {
        if (duration == null) {
            this.writeEmptyCell();
            return;
        }
        double numberOfDays = (double)duration.toMinutes() / 1440.0;
        this.writeCell((Number)numberOfDays, styleName);
    }

    public void writeOffsetlDateTime(OffsetDateTime time, ZoneId timeZone, String styleName) {
        if (time == null) {
            this.writeEmptyCell();
            return;
        }
        LocalDateTime localDate = time.atZoneSameInstant(timeZone).toLocalDateTime();
        Cell cell = this.addCell();
        cell.setCellStyle((CellStyle)this.styles.get(styleName));
        cell.setCellValue(localDate);
    }

    public void writeBonusDuration(Collection<AppliedBonus> bonus, String styleName) {
        if (bonus == null) {
            this.writeEmptyCell();
            return;
        }
        Duration totalBonusDuration = bonus.stream().map(AppliedBonus::getDuration).reduce(Duration.ZERO, (d1, d2) -> d1.plus((Duration)d2));
        this.writeCell(totalBonusDuration, styleName);
    }

    public void writeZoneName(Pdm pdm) {
        if (pdm.getZone() == null) {
            this.writeEmptyCell();
        } else {
            this.writeCell(pdm.getZone().getName());
        }
    }

    public void writeTariffName(TariffInfo ti) {
        if (ti == null) {
            this.writeEmptyCell();
        } else {
            this.writeCell(ti.getName());
        }
    }
}

