/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.data_tables.export;

import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.ui.controllers.PdmFilterRepository;
import de.rtb.pcon.ui.controllers.logbooks.LogbookClearingRepository;
import de.rtb.pcon.ui.data_tables.ClearingRequest;
import de.rtb.pcon.ui.data_tables.export.UserBackgroundJob;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcontrol.utils.ExcelOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ExportClearingsToExcelTask
extends UserBackgroundJob {
    private static final Logger logger = LoggerFactory.getLogger(ExportClearingsToExcelTask.class);
    private ClearingRequest dtRequest;

    public ExportClearingsToExcelTask(User user, Locale locale, ClearingRequest request) {
        super(user, locale);
        this.dtRequest = request;
    }

    public void export() {
        LogbookClearingRepository logbookClearingRepository = (LogbookClearingRepository)this.getApplicationContext().getBean(LogbookClearingRepository.class);
        PdmFilterRepository pdmFilterRepo = (PdmFilterRepository)this.getApplicationContext().getBean(PdmFilterRepository.class);
        I18nService i18nService = (I18nService)this.getApplicationContext().getBean(I18nService.class);
        PlatformTransactionManager platformTransactionManager = (PlatformTransactionManager)this.getApplicationContext().getBean(PlatformTransactionManager.class);
        ZoneId userTimeZone = ZoneId.of(this.getRequester().getTimeZoneName());
        this.setOutLocation(new File(this.getOutLocation(), this.generateRandomFileName("clr", ".xlsx")));
        try (ExcelOutputStream eos = new ExcelOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.getOutLocation())), true);){
            eos.registerDateTimeStyle("dateTimeMin", i18nService.getLocalizedMessageWithLocale("excel.format.datetime.short.minutes", this.getLocale(), new Object[0]));
            eos.registerDateTimeStyle("dateTimeSec", i18nService.getLocalizedMessageWithLocale("excel.format.datetime.short.seconds", this.getLocale(), new Object[0]));
            eos.addSheet(i18nService.getLocalizedMessageWithLocale("excel.emptySheetName", this.getLocale(), new Object[0]));
            eos.writeHeaderRow(new String[]{i18nService.getLocalizedMessageWithLocale("comp.table.header.label.gac", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.pdmNumber", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.pdm", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("logbook.cashbox.heading.clearingNumber", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.amount", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("global.label.currency", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.paymentType", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.datePdm", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.dateServer", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("logbook.cashbox.heading.clearingAsn", this.getLocale(), new Object[0])});
            TransactionTemplate transactionTemplate = new TransactionTemplate(platformTransactionManager);
            transactionTemplate.setReadOnly(true);
            transactionTemplate.executeWithoutResult(transactionStatus -> {
                List pdms = pdmFilterRepo.findBySelector(this.dtRequest.getPdmSelector(), this.getRequester());
                try (Stream clearingStream = logbookClearingRepository.streamClearings((Collection)pdms, this.dtRequest);){
                    clearingStream.forEach(clearing -> {
                        eos.addRow();
                        eos.writeCell(clearing.getPdm().getZone().getArea().getName());
                        eos.writeCell((Number)clearing.getPdm().getNumber());
                        eos.writeCell(clearing.getPdm().getName());
                        eos.writeCell((Number)clearing.getClearingNumber());
                        eos.writeCell((Number)clearing.getValueSold().doubleValue());
                        eos.writeCell(clearing.getCurrency());
                        eos.writeCell(i18nService.getEnumLocalText((Enum)clearing.getPaymentType(), this.getLocale()));
                        eos.writeOffsetlDateTime(clearing.getPdmTime(), userTimeZone, "dateTimeMin");
                        eos.writeOffsetlDateTime(clearing.getServerTime(), userTimeZone, "dateTimeSec");
                        eos.writeCell((Number)clearing.getAsn());
                        this.getEntityManager().detach(clearing);
                    });
                }
            });
        }
        catch (IOException e) {
            logger.error("Error by exporting clearings to excel.", (Throwable)e);
        }
    }
}

