/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmOperationalMode;
import de.rtb.pcon.ui.controllers.model.UiPdmStatus;
import de.rtb.pcon.ui.controllers.model.UiStatusMessage;
import de.rtb.pcon.ui.controllers.model.UiStatusMessageConfig;
import java.util.Collection;
import java.util.HashSet;

public class UiPdmWithIssue
extends UiPdmStatus {
    @JsonProperty(value="nr")
    private int number;
    private String name;
    private int area;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    private PdmOperationalMode opMode;
    @JsonProperty(value="om")
    private Collection<UiStatusMessage> openMessages;

    public UiPdmWithIssue(Pdm pdm) {
        super(pdm.getId(), AlertType.NONE);
        this.name = pdm.getName();
        this.number = pdm.getNumber();
        this.area = pdm.getZone().getArea().getId();
        this.opMode = pdm.getOpMode();
        this.openMessages = new HashSet();
    }

    public UiPdmWithIssue(Pdm pdm, Collection<UiStatusMessage> sts) {
        super(pdm.getId(), sts.stream().map(UiStatusMessageConfig::getAlert).max((a, b) -> a.compareTo((Enum)b)).orElse(AlertType.NONE));
        this.name = pdm.getName();
        this.number = pdm.getNumber();
        this.area = pdm.getZone().getArea().getId();
        this.opMode = pdm.getOpMode();
        this.openMessages = new HashSet<UiStatusMessage>(sts);
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getArea() {
        return this.area;
    }

    public void setArea(int area) {
        this.area = area;
    }

    public Collection<UiStatusMessage> getOpenMessages() {
        return this.openMessages;
    }

    public void setOpenMessages(Collection<UiStatusMessage> stats) {
        this.openMessages = stats;
    }
}

