/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.rtb.pcon.ui.controllers.model.UiChartCollector;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;

public class UiChartCollector<C, V> {
    private Table<String, C, Optional<V>> data;
    private V defaultValue;
    private Collection<C> enforcedCategories;

    public UiChartCollector(V defaultValue) {
        this.defaultValue = defaultValue;
        this.data = HashBasedTable.create();
        this.enforcedCategories = Collections.emptySet();
    }

    public void enforceCategories(Collection<C> enforcedCategories) {
        this.enforcedCategories = enforcedCategories;
    }

    public void addValue(String series, C category, V value) {
        Optional<Object> tableValue = value == null ? Optional.empty() : Optional.of(value);
        this.data.put((Object)series, category, tableValue);
    }

    public ChartData build() {
        ChartData gResult = new ChartData();
        LinkedHashSet categories = new LinkedHashSet();
        categories.addAll(this.enforcedCategories);
        categories.addAll(this.data.columnKeySet());
        gResult.put((Object)"labels", categories);
        LinkedList gSeries = new LinkedList();
        for (String serieName : this.data.rowKeySet()) {
            HashMap<String, Object> gSerie = new HashMap<String, Object>();
            gSerie.put("label", serieName);
            LinkedList<Object> gSerieData = new LinkedList<Object>();
            for (Object category : categories) {
                Optional value = (Optional)this.data.get((Object)serieName, category);
                if (value == null) {
                    gSerieData.add(this.defaultValue);
                    continue;
                }
                if (value.isPresent()) {
                    gSerieData.add(value.get());
                    continue;
                }
                gSerieData.add(null);
            }
            gSerie.put("data", gSerieData);
            gSeries.add(gSerie);
        }
        gResult.put((Object)"datasets", gSeries);
        return gResult;
    }
}

