/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.wes;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.wes.WesConfigDto;
import de.rtb.pcon.features.partners.wes.WesConfigService;
import de.rtb.pcon.features.partners.wes.WesException;
import de.rtb.pcon.features.partners.wes.WesParkingPass;
import de.rtb.pcon.features.partners.wes.WesValidateParkingPassReqBody;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
class WesRtrRequest
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(WesRtrRequest.class);
    private static final String MNEM_ERROR_CODE = "errorCode";
    private final RestTemplate restTemplate;
    private final WesConfigService configService;

    public WesRtrRequest(@Qualifier(value="rt3rdPartyApi") RestTemplate restTemplate, WesConfigService configService) {
        this.restTemplate = restTemplate;
        this.configService = configService;
    }

    public int getId() {
        return 18;
    }

    public String getDescription() {
        return "WES parking pass";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        HashedMap result = new HashedMap();
        Pdm pdm = ctx.global().getPdm();
        String wsb = ctx.getLocalString("WSB");
        int pan = ctx.getLocalInteger("PAN");
        WesConfigDto config = (WesConfigDto)this.configService.fetchConfig(pdm.getZone().getArea());
        if (!config.enabled()) {
            return Map.of(MNEM_ERROR_CODE, 1);
        }
        HashMap<String, Object> pdmPass = new HashMap<String, Object>();
        try {
            WesParkingPass pass = this.verifyUserPass(wsb, pan, config);
            ZoneId timeZoneId = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
            if (pass.getValidityTimestamp() != null) {
                pdmPass.put("validFrom", DateTimeUtils.toLocalDateTime((OffsetDateTime)pass.getValidityTimestamp(), (ZoneId)timeZoneId));
            } else {
                pdmPass.put("validFrom", null);
            }
            if (pass.getExpirationTimestamp() != null) {
                pdmPass.put("validTo", DateTimeUtils.toLocalDateTime((OffsetDateTime)pass.getExpirationTimestamp(), (ZoneId)timeZoneId));
            } else {
                pdmPass.put("validTo", null);
            }
            pdmPass.put("valid", pass.getPassValid());
            pdmPass.put("available", pass.getAvailable());
            pdmPass.put(MNEM_ERROR_CODE, pass.getErrorType());
            pdmPass.put("tariffName", pass.getParkingFare());
            if (pass.getParkingFare() == null) {
                pdmPass.put("tariffIndex", null);
            } else {
                int tariffIndex = -1;
                int i = 0;
                for (TariffInfo ti : pdm.getTariffInfos()) {
                    if (ti.getName().equals(pass.getParkingFare())) {
                        tariffIndex = i;
                        break;
                    }
                    ++i;
                }
                pdmPass.put("tariffIndex", tariffIndex + 1);
            }
        }
        catch (WesException e) {
            pdmPass.put(MNEM_ERROR_CODE, "SERVICE_ERROR");
        }
        result.put((Object)"WES", pdmPass);
        return result;
    }

    public WesParkingPass verifyUserPass(String userId, int placeNumber, WesConfigDto config) throws WesException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        HttpEntity postEntity = new HttpEntity((Object)new WesValidateParkingPassReqBody(userId, placeNumber), (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(config.baseUrl(), (Object)postEntity, WesParkingPass.class, new Object[0]);
            return (WesParkingPass)response.getBody();
        }
        catch (HttpClientErrorException e) {
            log.error("Request to WES failed.", (Throwable)e);
            throw new WesException();
        }
    }
}

