/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.satispay;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.satispay.SatispayConfigDto;
import de.rtb.pcon.features.partners.satispay.SatispayConfigService;
import de.rtb.pcon.features.partners.satispay.SatispayEnvionment;
import de.rtb.pcon.features.partners.satispay.SatispayKeyGenerationRequestDto;
import de.rtb.pcon.features.partners.satispay.SatispayService;
import de.rtb.pcon.features.partners.satispay.SatispayUtils;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaPartnerType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{areaId}/partners/satispay/"})
class SatispayController {
    private final SatispayService satispayService;
    private static final Logger log = LoggerFactory.getLogger(SatispayController.class);
    private final SatispayConfigService cfgService;
    private final SecureEntityLoaderService entityLoader;
    private final RestClient restClient;

    public SatispayController(SatispayConfigService cfgService, SecureEntityLoaderService entityLoader, RestClient restClient, SatispayService satispayService) {
        this.cfgService = cfgService;
        this.entityLoader = entityLoader;
        this.restClient = restClient;
        this.satispayService = satispayService;
    }

    @GetMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional(readOnly=true)
    public Map<String, Object> getConfig(@PathVariable int areaId) {
        Area area = this.entityLoader.loadArea(areaId);
        SatispayConfigDto c = (SatispayConfigDto)this.cfgService.fetchConfig(area);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("enabled", c.enabled());
        result.put("environment", c.environment().ordinal());
        SatispayConfigDto.SatispayKey s6yKey = c.key();
        if (s6yKey != null) {
            result.put("keyId", s6yKey.satispayId());
        }
        return result;
    }

    @PutMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional
    public void setConfig(@PathVariable int areaId, @RequestBody SatispayConfigDto config) {
        Area area = this.entityLoader.loadArea(areaId);
        SatispayConfigDto dbConfig = (SatispayConfigDto)this.cfgService.fetchConfig(area);
        SatispayConfigDto newConfig = new SatispayConfigDto(config.enabled(), dbConfig.environment(), dbConfig.key());
        this.cfgService.updateConfig(area, (PartnerConfiguration)newConfig);
    }

    @DeleteMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional
    public void deleteConfig(@PathVariable int areaId) {
        Area area = this.entityLoader.loadArea(areaId);
        this.cfgService.deleteConfig(area, AreaPartnerType.SATISPAY);
    }

    @PostMapping(value={"register-shop"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional
    ResponseEntity<Object> registerShop(@PathVariable int areaId, @RequestBody SatispayKeyGenerationRequestDto body) throws NoSuchAlgorithmException {
        int errorStatusCode = 428;
        try {
            Boolean enabled = Optional.ofNullable(body.enabled()).orElse(false);
            String shopToken = Objects.requireNonNull(body.shopToken(), "Please provide shop token");
            SatispayEnvionment environment = Objects.requireNonNull(body.environment(), "Please provide environment type");
            Area area = this.entityLoader.loadArea(areaId);
            log.info("Generating new RSA key");
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(4096);
            KeyPair keyPair = keyGen.generateKeyPair();
            String privateKeyBase64 = Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded());
            String publlicKeyBase64 = Base64.getEncoder().encodeToString(keyPair.getPublic().getEncoded());
            log.info("Registering RSA key by Satispay");
            String publicKeyPem = SatispayUtils.formatKey((String)publlicKeyBase64, (String)"public");
            URI uri = UriComponentsBuilder.fromUri((URI)environment.endpoint()).pathSegment(new String[]{"g_business", "v1", "authentication_keys"}).build().toUri();
            Map<String, String> s6yBody = Map.of("public_key", publicKeyPem, "token", shopToken);
            ResponseEntity s6yRes = ((RestClient.RequestBodySpec)this.restClient.post().uri(uri)).contentType(MediaType.APPLICATION_JSON).body(s6yBody).retrieve().toEntity(ObjectNode.class);
            Optional<String> s6yKeyId = Optional.ofNullable(((ObjectNode)s6yRes.getBody()).get("key_id")).map(JsonNode::textValue);
            if (s6yKeyId.isEmpty()) {
                return ResponseEntity.status((int)errorStatusCode).body(Map.of("error", "Key ID was not returned from Satispay", "httpStatus", s6yRes.getStatusCode().value(), "body", (Serializable)s6yRes.getBody()));
            }
            SatispayConfigDto.SatispayKey s6key = new SatispayConfigDto.SatispayKey(privateKeyBase64, publlicKeyBase64, s6yKeyId.get());
            SatispayConfigDto newConfig = new SatispayConfigDto(enabled.booleanValue(), environment, s6key);
            this.cfgService.updateConfig(area, (PartnerConfiguration)newConfig);
            return ResponseEntity.ok(Map.of("keyId", s6yKeyId));
        }
        catch (RestClientResponseException e) {
            return ResponseEntity.status((int)errorStatusCode).body(Map.of("error", "Key registration failed", "httpStatus", e.getStatusCode().value(), "body", (Serializable)e.getResponseBodyAs(ObjectNode.class)));
        }
        catch (Exception e) {
            return ResponseEntity.status((int)errorStatusCode).body(Map.of("error", e.getMessage()));
        }
    }

    @GetMapping(value={"key/generate"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    SatispayConfigDto.SatispayKey generateRsaPrivateKey(@PathVariable int areaId) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(4096);
        KeyPair keyPair = keyGen.generateKeyPair();
        Area area = this.entityLoader.loadArea(areaId);
        SatispayConfigDto config = (SatispayConfigDto)this.cfgService.fetchConfig(area);
        String privateKeyBase64 = Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded());
        String publlicKeyBase64 = Base64.getEncoder().encodeToString(keyPair.getPublic().getEncoded());
        SatispayConfigDto.SatispayKey key = new SatispayConfigDto.SatispayKey(privateKeyBase64, publlicKeyBase64, "");
        SatispayConfigDto newConfig = new SatispayConfigDto(config.enabled(), config.environment(), key);
        this.cfgService.updateConfig(area, (PartnerConfiguration)newConfig);
        return new SatispayConfigDto.SatispayKey(SatispayUtils.formatKey((String)publlicKeyBase64, (String)"public"), SatispayUtils.formatKey((String)publlicKeyBase64, (String)"private"), key.satispayId());
    }

    @GetMapping(value={"key/register"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    public Map<String, Object> registerKey(@PathVariable int areaId, @RequestParam String token) {
        Area area = this.entityLoader.loadArea(areaId);
        SatispayConfigDto config = (SatispayConfigDto)this.cfgService.fetchConfig(area);
        SatispayConfigDto.SatispayKey key = Objects.requireNonNull(config.key(), "Satispay key must exist to be able to register it.");
        String publicKeyPem = SatispayUtils.formatKey((String)key.publicKey(), (String)"public");
        log.info("Registering key, token {}, {}, {}", new Object[]{token, config.environment(), config.environment().endpoint()});
        URI uri = UriComponentsBuilder.fromUri((URI)config.environment().endpoint()).pathSegment(new String[]{"g_business", "v1", "authentication_keys"}).build().toUri();
        Map<String, String> body = Map.of("public_key", publicKeyPem, "token", token);
        ResponseEntity s6yResRaw = (ResponseEntity)((RestClient.RequestBodySpec)this.restClient.post().uri(uri)).contentType(MediaType.APPLICATION_JSON).body(body).exchange(SatispayController.exchangeJsonSafeHeaders());
        ResponseEntity s6yRes = Objects.requireNonNull(s6yResRaw, "Satispay request did not returned any response");
        ObjectNode s6yBody = Objects.requireNonNull((ObjectNode)s6yRes.getBody(), "Response body must be returned by  Satispay");
        SatispayConfigDto.SatispayKey newKey = new SatispayConfigDto.SatispayKey(key.privateKey(), key.publicKey(), s6yBody.get("key_id").asText());
        SatispayConfigDto newConfig = new SatispayConfigDto(config.enabled(), config.environment(), newKey);
        this.cfgService.updateConfig(area, (PartnerConfiguration)newConfig);
        log.info("Satispay response {}", (Object)s6yBody);
        return Map.of("status", s6yRes.getStatusCode().value(), "body", s6yRes.getBody());
    }

    @GetMapping(value={"test/auth"})
    Object testAuthentication(@PathVariable int areaId) {
        Area area = this.entityLoader.loadArea(areaId);
        SatispayConfigDto config = (SatispayConfigDto)this.cfgService.fetchConfig(area);
        URI serviceUri = UriComponentsBuilder.fromUri((URI)config.environment().endpoint()).pathSegment(new String[]{"wally-services", "protocol", "tests", "signature"}).build().encode().toUri();
        String body = "";
        log.info("Body {}", (Object)body);
        String digest = SatispayUtils.createDigest((String)body);
        log.info("Digest of body {}", (Object)digest);
        String hHost = serviceUri.getHost();
        String hDate = DateTimeFormatter.RFC_1123_DATE_TIME.format(OffsetDateTime.now());
        String messageToSign = "(request-target): post " + serviceUri.getPath() + "\nhost: " + hHost + "\ndate: " + hDate + "\ndigest: " + digest;
        log.info("Message to sing \n{}", (Object)messageToSign);
        PrivateKey privateKey = SatispayUtils.readPrivateKey((String)config.key().privateKey());
        String signature = SatispayUtils.signData((String)messageToSign, (PrivateKey)privateKey);
        log.info("signature:{}", (Object)signature);
        String hAuthorization = String.format("Signature keyId=\"%s\", algorithm=\"rsa-sha256\", headers=\"(request-target) host date digest\", signature=\"%s\"", config.key().satispayId(), signature);
        log.info("Authorization:{}", (Object)hAuthorization);
        ObjectNode response = (ObjectNode)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(serviceUri)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON})).header("Host", new String[]{hHost})).header("Date", new String[]{hDate})).header("Digest", new String[]{digest})).header("Authorization", new String[]{hAuthorization})).retrieve().body(ObjectNode.class);
        log.info("Response: {}", (Object)response);
        return response;
    }

    @GetMapping(value={"test/pay"})
    @Transactional(readOnly=true)
    Object testPay(@PathVariable int areaId) {
        Area area = this.entityLoader.loadArea(areaId);
        Pdm pdm = (Pdm)((Zone)area.getZones().get(0)).getPdms().get(0);
        OffsetDateTime payStart = OffsetDateTime.now();
        OffsetDateTime payEnd = payStart.plusMinutes(RandomUtils.insecure().randomLong(0L, 90L));
        return this.satispayService.createPayment(pdm, new BigDecimal("0.5"), "EUR", UUID.randomUUID().toString(), payStart, payEnd);
    }

    @GetMapping(value={"test/detail/{paymentId}"})
    @Transactional(readOnly=true)
    Object testPay(@PathVariable int areaId, @PathVariable String paymentId) {
        Area area = this.entityLoader.loadArea(areaId);
        Pdm pdm = (Pdm)((Zone)area.getZones().get(0)).getPdms().get(0);
        return this.satispayService.getPayment(pdm, paymentId, Optional.of(60));
    }

    @GetMapping(value={"test/cancel/{paymentId}"})
    @Transactional(readOnly=true)
    Object testCancel(@PathVariable int areaId, @PathVariable String paymentId) {
        Area area = this.entityLoader.loadArea(areaId);
        Pdm pdm = (Pdm)((Zone)area.getZones().get(0)).getPdms().get(0);
        return this.satispayService.cancelPayment(pdm, paymentId);
    }

    static RestClient.RequestHeadersSpec.ExchangeFunction<ResponseEntity<ObjectNode>> exchangeJsonSafeHeaders() {
        Set<String> badHeaders = Set.of("content-length", "date", "server", ":status");
        UnaryOperator filterHeaders = h -> {
            HttpHeaders nh = new HttpHeaders();
            h.forEach((key, value) -> {
                if (!badHeaders.contains(key.toLowerCase())) {
                    nh.put(key, value);
                }
            });
            return nh;
        };
        return (request, response) -> ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)response.getStatusCode()).headers((HttpHeaders)filterHeaders.apply(response.getHeaders()))).body((Object)((ObjectNode)response.bodyTo(ObjectNode.class)));
    }
}

