/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.pagopa;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.pagopa.PagoPaConfigDto;
import de.rtb.pcon.features.partners.pagopa.PagoPaConfigService;
import de.rtb.pcon.features.partners.pagopa.PagoPaRaStatusRequestPdmDto;
import de.rtb.pcon.features.partners.pagopa.PagoPaWsGateway;
import de.rtb.pcon.model.Area;
import it.pagaonlinepa.preprod.RaPaymentStatusInput;
import it.pagaonlinepa.preprod.RaPaymentStatusOutput;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class PagoPaRaStatusRtr
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(PagoPaRaStatusRtr.class);
    private final PagoPaWsGateway pagoPaClient;
    private final PagoPaConfigService configService;

    public PagoPaRaStatusRtr(PagoPaWsGateway pagoPaClient, PagoPaConfigService configService) {
        this.pagoPaClient = pagoPaClient;
        this.configService = configService;
    }

    public int getId() {
        return 68;
    }

    public String getDescription() {
        return "PagoPA RA_Payment_Status";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        PagoPaRaStatusRequestPdmDto pdmReq = (PagoPaRaStatusRequestPdmDto)ctx.getLocalObject("pago", PagoPaRaStatusRequestPdmDto.class);
        Area area = ctx.global().getPdm().getZone().getArea();
        log.info("{}: {}.", (Object)this.getDescription(), (Object)pdmReq);
        PagoPaConfigDto config = (PagoPaConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1, "ERM", "PagoPa partner is disabled.");
        }
        RaPaymentStatusInput raConfirmInput = this.pagoPaClient.createRaPaymentStatusInput();
        raConfirmInput.setPaymentID(pdmReq.paymentID().longValue());
        raConfirmInput.setTotemID("1110027");
        RaPaymentStatusOutput pagoPaResponse = this.pagoPaClient.raConfirm(raConfirmInput);
        return Map.of("pago", pagoPaResponse);
    }
}

