/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.user_data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionException;
import de.rtb.pcon.core.user_data.OpenMode;
import de.rtb.pcon.core.user_data.TransferEncoding;
import de.rtb.pcon.core.user_data.TransferStatus;
import de.rtb.pcon.model.EnumIndexOutOfBoundsException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
record UserDataTransferRequestDto(TransferStatus transferStatus, Optional<String> contentType, Optional<String> encodedData, TransferEncoding transferEncoding, String fileName, OpenMode openMode, Optional<Integer> fileSize, Optional<LocalDateTime> fileCreationTime, Integer partNumber, Optional<Integer> partsTotal) {
    private final TransferStatus transferStatus;
    private final Optional<String> contentType;
    private final Optional<String> encodedData;
    private final TransferEncoding transferEncoding;
    private final String fileName;
    private final OpenMode openMode;
    private final Optional<Integer> fileSize;
    private final Optional<LocalDateTime> fileCreationTime;
    private final Integer partNumber;
    private final Optional<Integer> partsTotal;

    UserDataTransferRequestDto(TransferStatus transferStatus, Optional<String> contentType, Optional<String> encodedData, TransferEncoding transferEncoding, String fileName, OpenMode openMode, Optional<Integer> fileSize, Optional<LocalDateTime> fileCreationTime, Integer partNumber, Optional<Integer> partsTotal) {
        this.transferStatus = transferStatus;
        this.contentType = contentType;
        this.encodedData = encodedData;
        this.transferEncoding = transferEncoding;
        this.fileName = fileName;
        this.openMode = openMode;
        this.fileSize = fileSize;
        this.fileCreationTime = fileCreationTime;
        this.partNumber = partNumber;
        this.partsTotal = partsTotal;
    }

    @JsonCreator
    public static UserDataTransferRequestDto fromJson(@JsonProperty(value="FTA") Optional<Integer> transferStatus, @JsonProperty(value="FTC") Optional<String> contentType, @JsonProperty(value="FTD") Optional<String> encodedData, @JsonProperty(value="FTE") Optional<String> transferEncodingName, @JsonProperty(value="FTN") String fileName, @JsonProperty(value="FTO") Optional<Integer> openMode, @JsonProperty(value="FTS") Optional<Integer> fileSize, @JsonProperty(value="FTT") Optional<LocalDateTime> fileCreationTime, @JsonProperty(value="FTY") Integer partNumber, @JsonProperty(value="FTZ") Optional<Integer> partsTotal) {
        try {
            return new UserDataTransferRequestDto(transferStatus.map(TransferStatus::fromValue).orElse(TransferStatus.IN_PROGRESS), contentType, encodedData, transferEncodingName.map(TransferEncoding::fromValue).orElse(TransferEncoding.BASE_64), fileName, openMode.map(OpenMode::fromValue).orElse(OpenMode.APPEND), fileSize, fileCreationTime, partNumber, partsTotal);
        }
        catch (EnumIndexOutOfBoundsException e) {
            throw new RealTimeRequestExecutionException(Map.of("abort", 1), "Can not parse request", (Throwable)e);
        }
    }

    public TransferStatus transferStatus() {
        return this.transferStatus;
    }

    public Optional<String> contentType() {
        return this.contentType;
    }

    public Optional<String> encodedData() {
        return this.encodedData;
    }

    public TransferEncoding transferEncoding() {
        return this.transferEncoding;
    }

    public String fileName() {
        return this.fileName;
    }

    public OpenMode openMode() {
        return this.openMode;
    }

    public Optional<Integer> fileSize() {
        return this.fileSize;
    }

    public Optional<LocalDateTime> fileCreationTime() {
        return this.fileCreationTime;
    }

    public Integer partNumber() {
        return this.partNumber;
    }

    public Optional<Integer> partsTotal() {
        return this.partsTotal;
    }
}

