/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.trc_check;

import de.rtb.pcon.config.DevelopmentProperties;
import de.rtb.pcon.core.runtime_monitor.AliveMonitorService;
import de.rtb.pcon.core.trc_check.TracerGuard;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmRuntimeMonitor;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
class TrcCacheService {
    private static final Logger log = LoggerFactory.getLogger(TrcCacheService.class);
    private static final int NO_TRACER_VALUE = -1;
    @Autowired
    private DevelopmentProperties devProps;
    @Autowired
    private AliveMonitorService runtimeService;

    TrcCacheService() {
    }

    @Cacheable(value={"tracer-guard"}, key="#pdm.getId()")
    public TracerGuard getTrcGuard(Pdm pdm) {
        Optional rt = this.runtimeService.getRuntimeInfo(pdm);
        Integer payment = rt.map(PdmRuntimeMonitor::getPayTracer).orElse(-1);
        Integer status = rt.map(PdmRuntimeMonitor::getStaTracer).orElse(-1);
        Integer clearing = rt.map(PdmRuntimeMonitor::getClrTracer).orElse(-1);
        Integer system = rt.map(PdmRuntimeMonitor::getSysTracer).orElse(-1);
        log.trace("Loading last tracers for PDM #{} into cache [payment, status, clearing, system] = [{}, {}, {}, {}].", new Object[]{pdm.getId(), payment, status, clearing, system});
        return new TracerGuard(payment.intValue(), status.intValue(), clearing.intValue(), system.intValue(), this.devProps.isDisableTrcCheck());
    }
}

