/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.printer_monitor;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.consts.AppConst;
import de.rtb.pcon.core.pdm.msg.json.device_report.DeviceReport;
import de.rtb.pcon.core.pdm.msg.json.device_report.PaperUsage;
import de.rtb.pcon.core.printer_monitor.PaperRoleChangeDto;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.PaperRole;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.repositories.PaperRoleRepository;
import de.rtb.pcon.repositories.PaperUsageRepository;
import de.rtb.pcon.repositories.PaymentTransactionRepository;
import de.rtb.pcon.repositories.StatusMessageRepository;
import de.rtb.pcontrol.utils.DateTimeUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrinterService {
    private static final Logger log = LoggerFactory.getLogger(PrinterService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PaymentTransactionRepository paymentRepo;
    @Autowired
    private StatusMessageRepository stausMessageRepo;
    @Autowired
    private PaperRoleRepository paperRoleRepo;
    @Autowired
    private PaperUsageRepository paperUsageRepo;
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper pdmObjectMapper;

    @Transactional(readOnly=true)
    public Optional<OffsetDateTime> findLastPaperRoleChangeFromStatusMessages(Pdm pdm) {
        return this.stausMessageRepo.findTop1ByPdmAndMessageConfigNumberAndPdmTimeAfterOrderByIdDesc(pdm, Short.valueOf((short)65), OffsetDateTime.now().minus(AppConst.LIMIT_PAPER_ROLE_CHANGED)).map(StatusMessage::getPdmTime);
    }

    public Optional<PaperRole> findCurrentPaperRole(Pdm pdm) {
        return this.paperRoleRepo.findTop1ByPdmAndOutTimeNullOrderByInTimeDesc(pdm);
    }

    public Optional<PaperRole> findLastPaperRole(Pdm pdm) {
        return this.paperRoleRepo.findTop1ByPdmAndOutTimeNotNullOrderByInTimeDesc(pdm);
    }

    public long countPrintedTickets(Pdm pdm, OffsetDateTime from) {
        return this.paymentRepo.countByIdPdmAndPaymentReasonAndIdPdmTimeBetween(pdm, PaymentReason.PURCHASE, from, OffsetDateTime.now());
    }

    @Transactional
    public void processPaperUsageReport(PdmMessageDto m) {
        if (m.getRdh() == null || m.getRdh().getPaper() == null) {
            return;
        }
        DeviceReport deviceReport = m.getRdh();
        log.debug("~ Paper report");
        OffsetDateTime period = DateTimeUtils.toOffsetDateTime((LocalDateTime)deviceReport.getPeriod(), (ZoneId)m.getTimeZone());
        PaperUsage paper = deviceReport.getPaper();
        float usedThisHour = (float)paper.getUsed();
        float usedTotal = (float)paper.getUsedTotal();
        int totalTickets = paper.getTicketsTotal();
        if (usedThisHour > 0.0f) {
            de.rtb.pcon.model.PaperUsage pu = new de.rtb.pcon.model.PaperUsage();
            pu.setPdm(m.getPdm());
            pu.setPdmTime(period);
            pu.setUsed(Float.valueOf(usedThisHour));
            this.paperUsageRepo.save((Object)pu);
            this.findCurrentPaperRole(m.getPdm()).ifPresent(paperRole -> {
                paperRole.setUsedLength(usedTotal);
                paperRole.setTickets(totalTickets);
            });
        }
    }

    @Transactional
    public void processPapereRoleChanged(PdmMessageDto m) {
        if (m.getPpr() == null) {
            return;
        }
        log.debug("~ Paper role changed");
        this.updatePaperRoleInDatabase(m.getPdm(), m.getDatTim(), m.getPpr());
    }

    void updatePaperRoleInDatabase(Pdm pdm, OffsetDateTime time, PaperRoleChangeDto paperRoleInfo) {
        this.findCurrentPaperRole(pdm).ifPresent(paperRole -> {
            paperRole.setOutTime(time);
            paperRole.setUsedLength(paperRoleInfo.used());
            paperRole.setTickets(paperRoleInfo.tickets());
        });
        PaperRole newRole = new PaperRole();
        newRole.setInTime(time);
        newRole.setRoleLength(paperRoleInfo.length());
        newRole.setPdm(pdm);
        newRole.setTickets(0);
        newRole.setUsedLength(0.0f);
        this.paperRoleRepo.save((Object)newRole);
    }
}

