/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.msg_fw;

import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.model.msgfw.MessageForwardingRule;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public record MessageForwardingRuleDefinition(int id, String name, String receivers, String languageTag, boolean active, @NonNull Set<Integer> pdmNumbers, @NonNull Set<Integer> messageNumbers, @NonNull Set<AlertType> alertTypes, @NonNull Set<DayOfWeek> daysOfWeek, LocalTime timeBegin, LocalTime timeEnd, ZoneId userTimeZone) {
    private final int id;
    private final String name;
    private final String receivers;
    private final String languageTag;
    private final boolean active;
    private final @NonNull Set<Integer> pdmNumbers;
    private final @NonNull Set<Integer> messageNumbers;
    private final @NonNull Set<AlertType> alertTypes;
    private final @NonNull Set<DayOfWeek> daysOfWeek;
    private final LocalTime timeBegin;
    private final LocalTime timeEnd;
    private final ZoneId userTimeZone;

    public MessageForwardingRuleDefinition(int id, String name, String receivers, String languageTag, boolean active, @NonNull Set<Integer> pdmNumbers, @NonNull Set<Integer> messageNumbers, @NonNull Set<AlertType> alertTypes, @NonNull Set<DayOfWeek> daysOfWeek, LocalTime timeBegin, LocalTime timeEnd, ZoneId userTimeZone) {
        this.id = id;
        this.name = name;
        this.receivers = receivers;
        this.languageTag = languageTag;
        this.active = active;
        this.pdmNumbers = pdmNumbers;
        this.messageNumbers = messageNumbers;
        this.alertTypes = alertTypes;
        this.daysOfWeek = daysOfWeek;
        this.timeBegin = timeBegin;
        this.timeEnd = timeEnd;
        this.userTimeZone = userTimeZone;
    }

    public static MessageForwardingRuleDefinition fromEntity(MessageForwardingRule ent, Set<Integer> essentialStatusNumbers) {
        Set roles = ent.getUser().getRoles();
        boolean canViewAllStatusMessages = roles != null && roles.contains(UserRole.ROLE_PCON_SUPPORT.name());
        boolean enabled = ent.isActive();
        Set<Object> selectedMessageNumbers = Optional.ofNullable(ent.getMessageNumbers()).map(Set::copyOf).orElse(Set.of());
        if (!canViewAllStatusMessages) {
            if (selectedMessageNumbers.isEmpty()) {
                selectedMessageNumbers = essentialStatusNumbers;
            } else if ((selectedMessageNumbers = selectedMessageNumbers.stream().filter(essentialStatusNumbers::contains).collect(Collectors.toSet())).isEmpty()) {
                enabled = false;
            }
        }
        return new MessageForwardingRuleDefinition(ent.getId().intValue(), ent.getName(), ent.getReceivers(), ent.getLanguageTag(), enabled, MessageForwardingRuleDefinition.makeImmutableSet((Collection)ent.getPdmNumbers()), selectedMessageNumbers, MessageForwardingRuleDefinition.makeImmutableSet((Collection)ent.getAlertTypes()), MessageForwardingRuleDefinition.makeImmutableSet((Collection)ent.getDaysOfWeek()), ent.getTimeBegin(), ent.getTimeEnd(), ZoneId.of(ent.getArea().getTimeZoneName()));
    }

    private static <T> Set<T> makeImmutableSet(Collection<T> src) {
        return src == null ? Set.of() : Set.copyOf(src);
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String receivers() {
        return this.receivers;
    }

    public String languageTag() {
        return this.languageTag;
    }

    public boolean active() {
        return this.active;
    }

    public @NonNull Set<Integer> pdmNumbers() {
        return this.pdmNumbers;
    }

    public @NonNull Set<Integer> messageNumbers() {
        return this.messageNumbers;
    }

    public @NonNull Set<AlertType> alertTypes() {
        return this.alertTypes;
    }

    public @NonNull Set<DayOfWeek> daysOfWeek() {
        return this.daysOfWeek;
    }

    public LocalTime timeBegin() {
        return this.timeBegin;
    }

    public LocalTime timeEnd() {
        return this.timeEnd;
    }

    public ZoneId userTimeZone() {
        return this.userTimeZone;
    }
}

