/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rtb.pcon.boot_app.ApplicationContextHolder;
import de.rtb.pcon.core.integration.Crc16Calculator;
import de.rtb.pcon.core.integration.IntegrationConsts;
import de.rtb.pcon.core.integration.MultiContenSiemens95Message;
import de.rtb.pcon.core.integration.PdmMessageProcessingException;
import de.rtb.pcon.core.integration.Siemens95MessageUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
class Siemens95MessageUtils {
    private static final Logger log = LoggerFactory.getLogger(Siemens95MessageUtils.class);
    private static final byte[] CRC_MARKER = ";CRC".getBytes(IntegrationConsts.PDM_MESSAGE_CHARSET);
    public static final String CRC_VALIDITY_KEY_NAME = "validCrc";
    private final ObjectMapper pdmObjectMapper = (ObjectMapper)ApplicationContextHolder.getBean((String)"pdmObjectMapper", ObjectMapper.class);
    private static final Pattern PAT_JSON_NUMBER = Pattern.compile("^\\d+\\.?\\d*$");
    private static final Pattern PAT_JSON_OBJECT = Pattern.compile("^\\{.*\\}$");
    private static final Pattern PAT_JSON_ARRAY = Pattern.compile("^\\[.*\\]$");
    private static final Pattern PAT_BOOLEAN = Pattern.compile("^(true|false)$");
    private static final Pattern PAT_NULL = Pattern.compile("^null$");
    private static final Set<String> KEYS_HEX_NUMBER = Set.of("FSA", "FSI", "AFB", "IPN", "PRT", "WIW", "SKE");
    private static final Set<String> KEYS_TEXT = Set.of("DAT", "TIM", "PED", "PET", "OPI", "OSM", "FMD", "FDD", "FXD", "ANF", "VZR", "TAR", "VEM", "VEP", "VEH");
    private static final Function<Object, String> MF_FIVE_DIGIT_DECIMAL_NUMBER = v -> String.format("%05d", v);
    private static final Map<String, Function<Object, String>> MNEMONIC_FORMATTER = Map.of("PSA", MF_FIVE_DIGIT_DECIMAL_NUMBER);

    Siemens95MessageUtils() {
    }

    public MultiContenSiemens95Message transformSiemens95ToJson(byte[] payload, boolean verifyCrc) {
        int crcStart = Siemens95MessageUtils.indexOf((byte[])payload, (byte[])CRC_MARKER);
        if (verifyCrc && crcStart == -1) {
            String msg = new String(payload, IntegrationConsts.PDM_MESSAGE_CHARSET);
            throw new PdmMessageProcessingException("Message from PDM does not contain CRC part: '" + msg + "'");
        }
        int endOfMessage = crcStart == -1 ? payload.length : crcStart + 1;
        byte[] msgBytes = Arrays.copyOf(payload, endOfMessage);
        boolean validCrc = true;
        String crcString = new String(payload, crcStart + CRC_MARKER.length, 4, IntegrationConsts.PDM_MESSAGE_CHARSET);
        if (verifyCrc) {
            validCrc = this.verifyCrc(msgBytes, crcString);
        }
        String msgStr = new String(msgBytes, IntegrationConsts.PDM_MESSAGE_CHARSET);
        try {
            Map mappedContent = this.mapMnemonics(msgStr);
            ObjectNode jsonNode = (ObjectNode)this.pdmObjectMapper.valueToTree((Object)mappedContent);
            jsonNode.put("validCrc", validCrc);
            return new MultiContenSiemens95Message(msgStr, crcString, jsonNode);
        }
        catch (UncheckedIOException e) {
            log.info(">>> [ <unknown> ] {}", (Object)msgStr);
            throw new PdmMessageProcessingException("Cannot parse message", (Throwable)e);
        }
    }

    private boolean verifyCrc(byte[] msgBytes, String expectedCrcStr) {
        Crc16Calculator crc16 = new Crc16Calculator();
        crc16.addBytes(msgBytes);
        int calculatedCrc = crc16.getCrc();
        int expectedCrc = Crc16Calculator.stringCrcToNumer((String)expectedCrcStr);
        return calculatedCrc == expectedCrc;
    }

    private Map<String, Object> mapMnemonics(String payload) {
        String[] msgData;
        LinkedHashMap<String, Object> mnemonicMap = new LinkedHashMap<String, Object>();
        for (String s : msgData = StringUtils.split((String)payload, (String)";")) {
            String val;
            String key = StringUtils.substring((String)s, (int)0, (int)3).toUpperCase();
            JsonNode v = this.narrowMnemonicValue(key, val = StringUtils.substring((String)s, (int)3));
            if (v == null) continue;
            mnemonicMap.put(key, v);
        }
        return mnemonicMap;
    }

    private @Nullable JsonNode narrowMnemonicValue(String key, String value) {
        try {
            if ("CCH".equals(key) && StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            String val = URLDecoder.decode(value, IntegrationConsts.PDM_MESSAGE_CHARSET);
            if (KEYS_TEXT.contains(key)) {
                return TextNode.valueOf((String)val);
            }
            if (KEYS_HEX_NUMBER.contains(key)) {
                return LongNode.valueOf((long)Long.parseLong(val, 16));
            }
            if (PAT_JSON_NUMBER.matcher(val).matches()) {
                return LongNode.valueOf((long)Long.parseLong(val));
            }
            if (PAT_JSON_OBJECT.matcher(val).matches() || PAT_JSON_ARRAY.matcher(val).matches() || PAT_BOOLEAN.matcher(val).matches() || PAT_NULL.matcher(val).matches()) {
                return this.parseFromJson(key, value);
            }
            return TextNode.valueOf((String)val);
        }
        catch (Exception e) {
            throw new PdmMessageProcessingException("Cannot narrow down value of mnemonic '" + key + "', with value '" + value + "'.", (Throwable)e);
        }
    }

    private JsonNode parseFromJson(String key, String val) {
        try {
            return (JsonNode)this.pdmObjectMapper.readValue(val, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Cannot parse value of mnemonic '" + key + "', value '" + val + "'", (IOException)((Object)e));
        }
    }

    private static int indexOf(byte[] array, byte[] target) {
        if (target.length == 0 || array.length < target.length) {
            return -1;
        }
        for (int i = 0; i <= array.length - target.length; ++i) {
            boolean found = true;
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] == target[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public String mapToMnemonic(Map.Entry<String, JsonNode> entry) {
        String name = entry.getKey();
        JsonNode valueNode = entry.getValue();
        String value = null;
        if (KEYS_HEX_NUMBER.contains(name)) {
            value = valueNode.asText();
        } else if (MNEMONIC_FORMATTER.containsKey(name)) {
            value = (String)((Function)MNEMONIC_FORMATTER.get(name)).apply(valueNode.asInt());
        } else {
            value = switch (1.$SwitchMap$com$fasterxml$jackson$databind$node$JsonNodeType[valueNode.getNodeType().ordinal()]) {
                case 1 -> "null";
                case 2, 3 -> Siemens95MessageUtils.minimalUrlEncoder((String)this.jsonNodeToMnemonicValue(valueNode));
                case 4 -> Siemens95MessageUtils.minimalUrlEncoder((String)valueNode.asText());
                default -> valueNode.asText();
            };
        }
        return name + value;
    }

    private String jsonNodeToMnemonicValue(JsonNode node) {
        Object result = null;
        try {
            result = this.pdmObjectMapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            result = "JSON error: " + e.getMessage();
        }
        return result;
    }

    public static String minimalUrlEncoder(String text) {
        StringBuilder result = new StringBuilder((int)(1.2 * (double)text.length()));
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            Object encoded = switch (c) {
                case '%' -> "%25";
                case ';' -> "%3B";
                case '\u0001' -> "%01";
                case '\u0003' -> "%03";
                default -> Character.valueOf(c);
            };
            result.append(encoded);
        }
        return result.toString();
    }
}

