/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.hw_components;

import de.rtb.pcon.core.hw_components.Pdm5Variant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

class PdmVersion {
    private static final Pattern PAT_VERSION = Pattern.compile("(?<major>\\d)\\.(?<minor>\\d+)\\.(?<variant>\\d+)\\.(?<build>\\d+)(\\s+(?<discrimination>[\\w\\d\\s]*))?");
    private String originalVersion = null;
    private int major = 1;
    private int minor = -1;
    private int variant = -1;
    private int build = -1;
    private String discrimination = null;

    public static PdmVersion fromString(String pdm5VersionString) {
        String ver = StringUtils.defaultString((String)pdm5VersionString).trim();
        Matcher m = PAT_VERSION.matcher(ver);
        if (m.matches()) {
            try {
                PdmVersion result = new PdmVersion();
                result.originalVersion = StringUtils.trim((String)pdm5VersionString);
                result.major = Integer.parseInt(m.group("major"));
                result.minor = Integer.parseInt(m.group("minor"));
                result.variant = Integer.parseInt(m.group("variant"));
                result.build = Integer.parseInt(m.group("build"));
                result.discrimination = m.group("discrimination");
                return result;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                throw new IllegalStateException("Cannot parse PDM 5 originalVersion '" + ver + "'.", e);
            }
        }
        throw new IllegalStateException("Cannot parse PDM5 originalVersion '" + ver + "'. Regular expression did not match.");
    }

    Pdm5Variant getPdm5Variant() {
        if (this.getMajor() >= 4 && this.getMajor() <= 5) {
            try {
                return Pdm5Variant.values()[this.variant];
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalStateException("Firmware variant cannot be inferred from value '" + this.variant + "'", e);
            }
        }
        throw new IllegalStateException("Firmware variant can be used only for firmwares 4 and 5. This is version " + this.getMajor());
    }

    public String toString() {
        StringBuilder vsb = new StringBuilder();
        vsb.append(this.major);
        vsb.append(".");
        vsb.append(this.minor);
        vsb.append(".");
        vsb.append(this.variant);
        vsb.append(".");
        vsb.append(this.build);
        if (this.discrimination != null) {
            vsb.append(" ");
            vsb.append(this.discrimination);
        }
        return vsb.toString();
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getVariant() {
        return this.variant;
    }

    public int getBuild() {
        return this.build;
    }

    public String getDiscrimination() {
        return this.discrimination;
    }
}

