/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download;

import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="pcon.pdm.active-download-notification")
@Validated
public class ActiveDownloadNotificationProperties {
    @DurationUnit(value=ChronoUnit.MINUTES)
    private Duration polingDelay = Duration.ofMinutes(15L);
    @DurationUnit(value=ChronoUnit.MINUTES)
    private Duration initialDelay = Duration.ofMinutes(5L);
    @Min(value=1L)
    @Max(value=100L)
    private @Min(value=1L) @Max(value=100L) int maxDownloads = 50;

    public Duration getPolingDelay() {
        return this.polingDelay;
    }

    public void setPolingDelay(Duration polingDelay) {
        this.polingDelay = polingDelay;
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(Duration initialDelay) {
        this.initialDelay = initialDelay;
    }

    public int getMaxDownloads() {
        return this.maxDownloads;
    }

    public void setMaxDownloads(int maxDownloads) {
        this.maxDownloads = maxDownloads;
    }
}

