/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import de.rtb.pcon.ui.controllers.model.UiMoney;
import de.rtb.pcon.ui.controllers.reports.revenue.UiRevenueByPdmRow;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UiRevenueByPdmReport {
    private final List<UiRevenueByPdmRow> rows;
    private final List<UiMoney> summary;

    public UiRevenueByPdmReport(List<UiRevenueByPdmRow> rows) {
        this.rows = rows;
        this.summary = this.caluculateSummary();
    }

    public static UiRevenueByPdmReport empty() {
        return new UiRevenueByPdmReport(List.of());
    }

    private List<UiMoney> caluculateSummary() {
        Map<String, BigDecimal> sumByCurrency = this.rows.stream().map(UiRevenueByPdmRow::getRevenue).collect(Collectors.toMap(UiMoney::getCurrency, UiMoney::getValue, (o, n) -> n.add((BigDecimal)o)));
        return sumByCurrency.entrySet().stream().map(e -> new UiMoney((BigDecimal)e.getValue(), (String)e.getKey())).sorted(Comparator.comparing(UiMoney::getCurrency)).toList();
    }

    public List<UiRevenueByPdmRow> getRows() {
        return this.rows;
    }

    public List<UiMoney> getSummary() {
        return this.summary;
    }
}

