/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategory;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

class SaleReportRowCategoryYearMonth
extends SaleReportRowCategory {
    private YearMonth delegate;

    public SaleReportRowCategoryYearMonth(int year, int month) {
        this.delegate = YearMonth.of(year, month);
    }

    public int compareTo(SaleReportRowCategory o) {
        if (this.getClass().equals(o.getClass())) {
            SaleReportRowCategoryYearMonth other = (SaleReportRowCategoryYearMonth)o;
            return this.delegate.compareTo(other.delegate);
        }
        throw new IllegalStateException("Types " + this.getClass().getName() + " and " + o.getClass().getName() + " are not comparable.");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SaleReportRowCategoryYearMonth other = (SaleReportRowCategoryYearMonth)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String toLocaleString(Locale locale) {
        return this.delegate.getYear() + " - " + this.delegate.getMonth().getDisplayName(TextStyle.FULL, locale);
    }

    public static Set<SaleReportRowCategory> generateCategoriesBetween(LocalDate from, LocalDate to) {
        TreeSet<SaleReportRowCategory> yearMonths = new TreeSet<SaleReportRowCategory>();
        LocalDate now = from;
        while (now.isBefore(to) || now.isEqual(to)) {
            yearMonths.add((SaleReportRowCategory)new SaleReportRowCategoryYearMonth(now.getYear(), now.getMonthValue()));
            now = now.plusDays(1L);
        }
        return yearMonths;
    }
}

