/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.ui.controllers.reports.payments.CategoryStrategy;
import java.math.BigDecimal;
import java.math.RoundingMode;

class CurrencyCategoryStrategy
implements CategoryStrategy<BigDecimal> {
    private static BigDecimal SMALLEST_CURRENCY_UNIT = new BigDecimal("0.01");
    private BigDecimal categoryLength;

    public CurrencyCategoryStrategy(BigDecimal categoryLength) {
        this.categoryLength = categoryLength;
    }

    public int category(BigDecimal value) {
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            return -1;
        }
        return value.divide(this.categoryLength, 0, RoundingMode.DOWN).intValue();
    }

    public BigDecimal minValue(int category) {
        if (category == -1) {
            return BigDecimal.ZERO;
        }
        BigDecimal minValue = this.categoryLength.multiply(new BigDecimal(category));
        if (category == 0 && BigDecimal.ZERO.compareTo(minValue) == 0) {
            minValue = minValue.add(SMALLEST_CURRENCY_UNIT);
        }
        return minValue;
    }

    public BigDecimal maxValue(int category) {
        if (category == -1) {
            return BigDecimal.ZERO;
        }
        return this.categoryLength.multiply(new BigDecimal(category + 1)).subtract(SMALLEST_CURRENCY_UNIT);
    }
}

