/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.core.open_messages.OpenMessagesService;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.ui.controllers.PdmFilterRepository;
import de.rtb.pcon.ui.controllers.model.UiStatusMessage;
import de.rtb.pcon.ui.controllers.model.filter.FilterPdmInclusive;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/"})
public class ParkingStatusController {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PdmFilterRepository pdmFilterRepo;
    @Autowired
    private OpenMessagesService statusMsgService;

    @GetMapping(value={"openMessages"})
    @PreAuthorize(value="isAuthenticated()")
    @Transactional
    public Map<Integer, List<UiStatusMessage>> getOpenMessagesByInclusiveFilter(@RequestParam(name="area", required=false) Set<Integer> uiAreaIds, @RequestParam(name="zone", required=false) Set<Integer> uiZoneIds, @RequestParam(name="pdm", required=false) Set<Integer> uiPdmIds) {
        FilterPdmInclusive pdmFilter = new FilterPdmInclusive(uiAreaIds, uiZoneIds, uiPdmIds);
        List pdmIds = this.pdmFilterRepo.findPdmsByInclusiveFilter(pdmFilter);
        Map<Integer, List<UiStatusMessage>> openMessages = this.statusMsgService.listUiOpenMessages((Collection)pdmIds).entrySet().stream().collect(Collectors.toMap(e -> ((Pdm)e.getKey()).getId(), e -> (List)e.getValue()));
        return openMessages;
    }
}

