/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.repositories.fw_update;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.download.DownloadStatus;
import jakarta.persistence.Tuple;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface DownloadPlanRepository
extends JpaRepository<DownloadPlan, Integer>,
JpaSpecificationExecutor<DownloadPlan> {
    @Query(value="SELECT plan.id as planId, status, count(*)\nFROM DownloadEntry\nWHERE plan IN (?1)\nGROUP BY plan.id, status")
    public List<Tuple> reportProgress(Collection<DownloadPlan> var1);

    @Modifying
    @Query(value="UPDATE DownloadEntry\nSET status = :dsAborted\nWHERE plan = :plan AND status= :dsQueued")
    public void abortPlan(@Param(value="plan") DownloadPlan var1, @Param(value="dsQueued") DownloadStatus var2, @Param(value="dsAborted") DownloadStatus var3);

    default public void abortPlan(DownloadPlan plan) {
        this.abortPlan(plan, DownloadStatus.QUEUED, DownloadStatus.ABORTED);
    }

    @Modifying
    @Query(value="UPDATE DownloadEntry\nSET status = :dsQueued\nWHERE status IN (:dsTransferFailed, :dsActivationFailed, :dsAborted)\nAND plan = :plan")
    public void retryPlan(@Param(value="plan") DownloadPlan var1, @Param(value="dsQueued") DownloadStatus var2, @Param(value="dsTransferFailed") DownloadStatus var3, @Param(value="dsActivationFailed") DownloadStatus var4, @Param(value="dsAborted") DownloadStatus var5);

    default public void retryPlan(DownloadPlan plan) {
        this.retryPlan(plan, DownloadStatus.QUEUED, DownloadStatus.TRANSFER_FAILED, DownloadStatus.ACTIVATION_FAILED, DownloadStatus.ABORTED);
    }

    @Query(value="SELECT COUNT(*) = 0\nFROM DownloadPlan p\nJOIN p.entries e\nWHERE p = :plan\nAND e.status NOT IN (:dsQueued, :dsAborted)")
    public boolean canBeDeleted(@Param(value="plan") DownloadPlan var1, @Param(value="dsQueued") DownloadStatus var2, @Param(value="dsAborted") DownloadStatus var3);

    default public boolean canBeDeleted(DownloadPlan plan) {
        return this.canBeDeleted(plan, DownloadStatus.QUEUED, DownloadStatus.ABORTED);
    }

    public Optional<DownloadPlan> findByIdAndArea(int var1, Area var2);
}

