/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.features.partners.rao.RaoUtils;
import de.rtb.pcon.features.partners.rao.model.RaoArticleCompanySelectorPdm;
import de.rtb.pcon.features.partners.rao.model.RaoArticlesSingleCompanyResponse;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrArticleList
implements RealTimeRequest {
    private final RestClient restClient;
    private final BlockingCallGuard blokcingCallGuard;
    private final RaoConfigService raoConfigService;
    private final RaoProperties raoProps;

    RaoRtrArticleList(@Qualifier(value="wc3rdPartyApi") RestClient restClient, BlockingCallGuard blokcingCallGuard, RaoConfigService raoConfigService, RaoProperties raoProps) {
        this.restClient = restClient;
        this.blokcingCallGuard = blokcingCallGuard;
        this.raoConfigService = raoConfigService;
        this.raoProps = raoProps;
    }

    public int getId() {
        return 62;
    }

    public String getDescription() {
        return "RAO, article list";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        return this.blokcingCallGuard.webCallExecute(() -> this.doWebCall(ctx));
    }

    private Map<String, Object> doWebCall(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        RaoConfigDto raoCfg = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
        RaoArticleCompanySelectorPdm pdmFilterReq = (RaoArticleCompanySelectorPdm)ctx.getLocalObject("filter", RaoArticleCompanySelectorPdm.class);
        if (StringUtils.isBlank((CharSequence)pdmFilterReq.companyId())) {
            throw new IllegalStateException("CompanyId must be provided.");
        }
        if (!raoCfg.enabled()) {
            return Map.of("ERC", 1);
        }
        Integer zoneId = ctx.findPdmEntity().getZone().getId();
        Optional<Pair> zoneFilterCfg = raoCfg.zones().stream().filter(z -> Objects.equals(z.rtbId(), zoneId)).findAny().map(z -> Pair.of((Object)raoCfg.zoneIdProperty(), (Object)z.raoId()));
        Optional zoneFilterUser = RaoUtils.createCompletePair((String)pdmFilterReq.zoneKey(), (String)pdmFilterReq.zoneValue());
        Optional<Pair> zoneFilter = zoneFilterUser.or(() -> zoneFilterCfg);
        Optional townFilter = RaoUtils.createCompletePair((String)raoCfg.townProperty(), (String)raoCfg.townValue());
        try {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"api", "rao", "articles", "companies", pdmFilterReq.companyId()});
            zoneFilter.ifPresent(f -> {
                uriBuilder.queryParam("zoneKey", new Object[]{((String)f.getKey()).toUpperCase()});
                uriBuilder.queryParam("zone", new Object[]{f.getValue()});
            });
            townFilter.ifPresent(f -> {
                uriBuilder.queryParam("townKey", new Object[]{((String)f.getKey()).toUpperCase()});
                uriBuilder.queryParam("town", new Object[]{f.getValue()});
            });
            Optional.ofNullable(pdmFilterReq.skip()).ifPresent(skip -> uriBuilder.queryParam("streamSkip", new Object[]{skip.toString()}));
            Optional.ofNullable(pdmFilterReq.limit()).ifPresent(lim -> uriBuilder.queryParam("streamLimit", new Object[]{lim.toString()}));
            URI uri = uriBuilder.encode().build().toUri();
            ResponseEntity articleResponseEntity = this.restClient.get().uri(uri).retrieve().toEntity(RaoArticlesSingleCompanyResponse.class);
            HttpHeaders raoHeaders = articleResponseEntity.getHeaders();
            HashMap pdmResponseHeaders = new HashMap();
            Optional.ofNullable(raoHeaders.getFirst("Data-Hash")).ifPresent(v -> pdmResponseHeaders.put("Data-Hash", v));
            Optional.ofNullable(raoHeaders.getFirst("Stream-Skip")).ifPresent(v -> pdmResponseHeaders.put("Stream-Skip", v));
            Optional.ofNullable(raoHeaders.getFirst("Stream-Limit")).ifPresent(v -> pdmResponseHeaders.put("Stream-Limit", v));
            Optional.ofNullable(raoHeaders.getFirst("Stream-Size")).ifPresent(v -> pdmResponseHeaders.put("Stream-Size", v));
            return Map.of("httpStatus", HttpStatus.OK.value(), "body", articleResponseEntity.getBody(), "headers", pdmResponseHeaders);
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (ResourceAccessException e) {
            return Map.of("ERC", 3, "ERM", "Cannot access Applejack API.");
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

