/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.easy_park;

import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.PartnerUtils;
import de.rtb.pcon.features.partners.easy_park.EpConfigAuth;
import de.rtb.pcon.features.partners.easy_park.EpConfigDto;
import de.rtb.pcon.features.partners.easy_park.EpConfigService;
import de.rtb.pcon.features.partners.easy_park.EpConfigZone;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaPartnerType;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{id}/partners/easy-park/"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class EpController {
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private EpConfigService cfgService;

    EpController() {
    }

    @GetMapping(value={"config"})
    @Transactional(readOnly=true)
    public EpConfigDto getConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        EpConfigDto cfg = (EpConfigDto)this.cfgService.fetchConfig(area);
        List epZones = PartnerUtils.adjustZones((List)area.getZones(), (List)cfg.zones(), zId -> new EpConfigZone(Integer.valueOf(zId), null));
        Optional<EpConfigAuth> authO = Optional.ofNullable(cfg.auth());
        return new EpConfigDto(cfg.enabled(), cfg.general(), new EpConfigAuth(authO.map(EpConfigAuth::authGateway).orElse(""), authO.map(EpConfigAuth::refreshToken).orElse("")), epZones, null);
    }

    @PutMapping(value={"config"})
    @Transactional
    public void setConfig(@PathVariable(value="id") Integer areaId, @RequestBody EpConfigDto cfgUi) {
        Area area = this.entityLoader.loadArea(areaId.intValue());
        EpConfigDto cfgExisting = (EpConfigDto)this.cfgService.fetchConfig(area);
        List<EpConfigZone> allowedZones = PartnerUtils.adjustZones((List)area.getZones(), (List)cfgUi.zones(), rtbId -> new EpConfigZone(Integer.valueOf(rtbId), null)).stream().filter(z -> z.areaNo() != null).toList();
        EpConfigDto cfgNew = new EpConfigDto(cfgUi.enabled(), cfgUi.general(), new EpConfigAuth(cfgUi.auth().authGateway(), cfgUi.auth().refreshToken()), allowedZones, cfgExisting.jwt());
        this.cfgService.updateConfig(area, (PartnerConfiguration)cfgNew);
    }

    @DeleteMapping(value={"config"})
    @Transactional
    public void deleteConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        this.cfgService.deleteConfig(area, AreaPartnerType.EASY_PARK);
    }
}

