/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners;

import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.PartnerConfigurationService;
import de.rtb.pcon.features.partners.PartnersController;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaPartnerType;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{id}/partners/"})
public class PartnersController {
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private PartnerConfigurationService partnerConfigService;

    @GetMapping(value={"status"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    public List<PartnerStatusDto> getConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        return this.partnerConfigService.fetchConfigs(area).entrySet().stream().map(c -> new PartnerStatusDto((AreaPartnerType)c.getKey(), ((PartnerConfiguration)c.getValue()).enabled())).toList();
    }
}

