/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_1;

import de.rtb.pcon.features.bonus.BonusUtils;
import de.rtb.pcon.features.bonus.multi_tariff_1.BonMt1Repository;
import de.rtb.pcon.features.bonus.multi_tariff_1.BonMt1RuleEntity;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.model.zone.Zone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
class BonMt1Service {
    @Autowired
    private BonMt1Repository bonusRepo;

    BonMt1Service() {
    }

    @Transactional
    public int deleteLpnEntries(Zone zone) {
        return this.bonusRepo.deleteByZone(zone);
    }

    @Transactional
    public void addLpnEntry(Zone zone, String lpn, TariffInfo tariffInfo) {
        BonMt1RuleEntity mte = new BonMt1RuleEntity();
        mte.setZone(zone);
        mte.setLpn(lpn);
        mte.setTariffInfo(tariffInfo);
        this.bonusRepo.save((Object)mte);
    }

    @Transactional(readOnly=true)
    public int findTariffIndex(String lpn, Pdm pdm) {
        if (pdm.getZone() == null) {
            return -1;
        }
        return this.bonusRepo.findByLpnAndZone(lpn, pdm.getZone()).map(rule -> BonusUtils.findTariffIndexByTariffName((String)rule.getTariffInfo().getName(), (Pdm)pdm)).orElse(0);
    }
}

