/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.gates;

import de.rtb.pcon.core.integration.PdmMessageProcessionException;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.gates.PresentTicketRepository;
import de.rtb.pcon.model.zone.Zone;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BonGateRtrDelete
implements RealTimeRequest {
    @Autowired
    private PresentTicketRepository repo;

    BonGateRtrDelete() {
    }

    public int getId() {
        return 34;
    }

    public String getDescription() {
        return "Gate, delete ticket";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Zone zone = ctx.global().getPdm().getZone();
        if (zone == null) {
            throw new PdmMessageProcessionException("PDM must be in zone.");
        }
        String ticketNumber = ctx.getLocalString("tn");
        int nrOfDeleted = this.repo.deleteByTicketNumberAndZone(ticketNumber, zone);
        return Map.of("deleted", nrOfDeleted);
    }
}

