/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.disposable;

import de.rtb.pcon.features.bonus.disposable.BonDisRuleEntity;
import de.rtb.pcon.features.bonus.disposable.BonDisRuleRepository;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelImportException;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
class BonDisService {
    private static final Logger logger = LoggerFactory.getLogger(BonDisService.class);
    private static final Pattern VALID_CODE = Pattern.compile("[A-Z0-9]{4,}");
    @Autowired
    private BonDisRuleRepository repo;
    @Autowired
    private I18nService i18n;

    BonDisService() {
    }

    @Transactional
    public Optional<BonDisRuleEntity> offer(String code, Zone zone) {
        return this.repo.findValidBonusByCode(code, zone);
    }

    @Transactional
    public void consume(String code, PaymentTransaction payment) {
        if (payment.getId().getPdm().getZone() == null) {
            logger.atWarn().setMessage("Cannot consume bonus '{}' for {} because it is not in any zone").addArgument((Object)code).addArgument(() -> LoggerUtils.log((Pdm)payment.getId().getPdm())).log();
            return;
        }
        Optional bonus = this.repo.findBonusByCode(code, payment.getId().getPdm().getZone());
        if (!bonus.isPresent()) {
            logger.atWarn().setMessage("Consumed bonus '{}' in {} doesn't exist").addArgument((Object)code).addArgument(() -> LoggerUtils.log((Zone)payment.getId().getPdm().getZone())).log();
            return;
        }
        ((BonDisRuleEntity)bonus.get()).setConsumer(payment);
    }

    @Transactional
    public void persist(BonDisRuleEntity bonus) {
        this.repo.save((Object)bonus);
    }

    public BonDisRuleEntity fromExelRow(Row row, Collection<TariffInfo> zoneTariffs, ZonedDateTime defaultValidFrom) throws ExcelImportException {
        BonDisRuleEntity bonus = new BonDisRuleEntity();
        ZoneId userTimeZoneId = defaultValidFrom.getZone();
        Cell c = row.getCell(0);
        if (c == null) {
            throw new ExcelImportException(row.getRowNum(), 0, this.i18n.getLocalizedMessage("document.import.excel.error.cell.notEmpty", new Object[0]));
        }
        if (CellType.STRING != c.getCellType()) {
            throw new ExcelImportException(row.getRowNum(), 0, this.i18n.getLocalizedMessage("document.import.excel.error.cell.text", new Object[0]));
        }
        String bonusCode = c.getStringCellValue().toUpperCase(Locale.ROOT);
        if (bonusCode.length() < 4) {
            throw new ExcelImportException(row.getRowNum(), 0, this.i18n.getLocalizedMessage("document.import.excel.disposable.codeTooShort", new Object[0]));
        }
        if (!VALID_CODE.matcher(bonusCode).matches()) {
            throw new ExcelImportException(row.getRowNum(), 0, this.i18n.getLocalizedMessage("document.import.excel.disposable.badCharacter", new Object[0]));
        }
        bonus.setCode(bonusCode);
        c = row.getCell(1);
        if (c == null || c.getCellType() == CellType.BLANK) {
            bonus.setDuration(Duration.ZERO);
        } else {
            if (c.getCellType() != CellType.NUMERIC) {
                throw new ExcelImportException(row.getRowNum(), 1, this.i18n.getLocalizedMessage("document.import.excel.error.cell.time", new Object[0]));
            }
            double durationInDays = c.getNumericCellValue();
            bonus.setDuration(Duration.ofMinutes(Math.round(durationInDays * 24.0 * 60.0)));
        }
        c = row.getCell(2);
        if (c == null || c.getCellType() == CellType.BLANK) {
            bonus.setDiscount(BigDecimal.ZERO);
        } else {
            if (c.getCellType() != CellType.NUMERIC) {
                throw new ExcelImportException(row.getRowNum(), 2, this.i18n.getLocalizedMessage("document.import.excel.error.cell.numeric", new Object[0]));
            }
            bonus.setDiscount(BigDecimal.valueOf(c.getNumericCellValue()));
        }
        c = row.getCell(3);
        if (c == null || c.getCellType() == CellType.BLANK) {
            bonus.setTariff(null);
        } else {
            if (CellType.STRING != c.getCellType()) {
                throw new ExcelImportException(row.getRowNum(), 3, this.i18n.getLocalizedMessage("document.import.excel.error.cell.text", new Object[0]));
            }
            bonus.setTariff(c.getStringCellValue());
        }
        c = row.getCell(4);
        if (c == null || c.getCellType() == CellType.BLANK) {
            bonus.setValidFrom(defaultValidFrom.toOffsetDateTime());
        } else {
            if (!DateUtil.isCellDateFormatted((Cell)c)) {
                throw new ExcelImportException(row.getRowNum(), 4, this.i18n.getLocalizedMessage("document.import.excel.error.cell.date", new Object[0]));
            }
            Date date = DateUtil.getJavaDate((double)c.getNumericCellValue());
            OffsetDateTime oValidFrom = date.toInstant().atZone(userTimeZoneId).toOffsetDateTime();
            bonus.setValidFrom(oValidFrom);
        }
        c = row.getCell(5);
        if (c == null || c.getCellType() == CellType.BLANK) {
            bonus.setValidTo(defaultValidFrom.plusYears(50L).toOffsetDateTime());
        } else {
            if (!DateUtil.isCellDateFormatted((Cell)c)) {
                throw new ExcelImportException(row.getRowNum(), 5, this.i18n.getLocalizedMessage("document.import.excel.error.cell.date", new Object[0]));
            }
            Date date = DateUtil.getJavaDate((double)c.getNumericCellValue());
            OffsetDateTime oValidTo = date.toInstant().atZone(userTimeZoneId).toOffsetDateTime();
            bonus.setValidTo(oValidTo);
        }
        return bonus;
    }
}

