/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.basic_1;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import de.rtb.pcon.features.bonus.AppliedBonus;
import de.rtb.pcon.features.bonus.AppliedBonusKind;
import de.rtb.pcon.features.bonus.AppliedBonusRepository;
import de.rtb.pcon.features.bonus.AppliedBonusSource;
import de.rtb.pcon.features.bonus.BonusValue;
import de.rtb.pcon.features.bonus.BrokenBonusValue;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1ConfigEntity;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1ConfigRepository;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1ExceptionEntity;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1ExceptionRepository;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentTransactionId;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
class BonBasic1Service {
    private static final Logger log = LoggerFactory.getLogger(BonBasic1Service.class);
    private AppliedBonusRepository appliedBonusRepo;
    private BonBasic1ConfigRepository bonusConfigRepo;
    private BonBasic1ExceptionRepository bonusExceptionRepo;
    private CronParser cronParser;

    public BonBasic1Service(AppliedBonusRepository appliedBonusRepo, BonBasic1ConfigRepository bonusConfigRepo, BonBasic1ExceptionRepository bonusExceptionRepo) {
        this.appliedBonusRepo = appliedBonusRepo;
        this.bonusConfigRepo = bonusConfigRepo;
        this.bonusExceptionRepo = bonusExceptionRepo;
        this.cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    }

    public static BonBasic1ConfigEntity createDefaultBonus(Zone zone) {
        BonBasic1ConfigEntity bonus = new BonBasic1ConfigEntity();
        bonus.setEmitCount(1);
        bonus.setEnabled(false);
        bonus.setDuration(Duration.ofMinutes(15L));
        bonus.setPrice(BigDecimal.ZERO);
        bonus.setRenewAt("0 0 0 ? * * *");
        bonus.setZone(zone);
        return bonus;
    }

    @Transactional(noRollbackFor={IllegalArgumentException.class})
    public Optional<BonusValue> findBonusValue(Pdm pdm, String lpn) {
        Optional bonusO = this.bonusConfigRepo.findBonusForPdm(pdm);
        if (bonusO.isEmpty()) {
            log.atWarn().setMessage("Bonus for {} is not defined.").addArgument(() -> LoggerUtils.log((Pdm)pdm)).log();
            return Optional.empty();
        }
        BonBasic1ConfigEntity bonus = (BonBasic1ConfigEntity)bonusO.get();
        if (!bonus.isEnabled()) {
            log.debug("Bonus is disabled.");
            return Optional.empty();
        }
        ZonedDateTime now = ZonedDateTime.now(ZoneId.of(pdm.getZone().getArea().getTimeZoneName()));
        try {
            Optional excelBonusO;
            ExecutionTime execTime = ExecutionTime.forCron((Cron)this.cronParser.parse(bonus.getRenewAt()));
            ZonedDateTime lastReset = (ZonedDateTime)execTime.lastExecution(now).get();
            log.trace("Cron pattern '{}', now {}, last reset {}.", new Object[]{bonus.getRenewAt(), now, lastReset});
            List givenBonuses = this.appliedBonusRepo.findUsedBonuses(AppliedBonusKind.BASIC_1, lpn, lastReset.toOffsetDateTime(), pdm.getZone().getArea());
            if (givenBonuses.size() >= bonus.getEmitCount()) {
                if (log.isDebugEnabled()) {
                    String usedBonusTime = givenBonuses.stream().map(PaymentTransaction::getId).map(PaymentTransactionId::getPdmTime).sorted(OffsetDateTime.timeLineOrder()).map(d -> "at " + d.toString()).collect(Collectors.joining(", "));
                    log.debug("All {} bonuses for '{}' has been used already ({}). Next possibility after {}.", new Object[]{bonus.getEmitCount(), lpn, usedBonusTime, execTime.nextExecution(now).get()});
                }
                return Optional.empty();
            }
            if (log.isDebugEnabled()) {
                log.debug("LPN '{}' got {}, {} from {} times.", new Object[]{lpn, LoggerUtils.log((BonusValue)bonus), givenBonuses.size() + 1, bonus.getEmitCount()});
            }
            if ((excelBonusO = this.bonusExceptionRepo.findByLpnAndBonus(lpn, bonus)).isPresent()) {
                BonBasic1ExceptionEntity excelBonus = (BonBasic1ExceptionEntity)excelBonusO.get();
                if (log.isDebugEnabled()) {
                    log.debug("Lpn '{}' got {} form excel definitions.", (Object)lpn, (Object)LoggerUtils.log((BonusValue)excelBonus));
                }
                return Optional.of(excelBonus);
            }
            return Optional.of(bonus);
        }
        catch (IllegalArgumentException e) {
            log.error("Cannot process bonus.", (Throwable)e);
            return Optional.empty();
        }
    }

    @Transactional
    public void recordUsage(PaymentTransaction payment) {
        Object bonusValue;
        Optional bonusO = this.bonusConfigRepo.findBonusForPdm(payment.getId().getPdm());
        if (bonusO.isPresent()) {
            BonBasic1ConfigEntity bonus = (BonBasic1ConfigEntity)bonusO.get();
            Optional excelBonusO = this.bonusExceptionRepo.findByLpnAndBonus(payment.getLpn(), bonus);
            bonusValue = excelBonusO.isPresent() ? (BonusValue)excelBonusO.get() : bonus;
        } else {
            bonusValue = new BrokenBonusValue();
        }
        this.recordUsage(payment, (BonusValue)bonusValue, AppliedBonusSource.SERVER);
    }

    @Transactional
    public void recordUsage(PaymentTransaction payment, BonusValue bonusValue, AppliedBonusSource bonusSource) {
        AppliedBonus ab = new AppliedBonus();
        ab.setPrice(Objects.requireNonNullElse(bonusValue.getPrice(), BigDecimal.ZERO));
        ab.setDuration(Objects.requireNonNullElse(bonusValue.getDuration(), Duration.ZERO));
        ab.setKind(AppliedBonusKind.BASIC_1);
        ab.setSource(bonusSource);
        ab.setPayment(payment);
        this.appliedBonusRepo.save((Object)ab);
    }

    @Transactional(readOnly=true)
    public Optional<BonBasic1ConfigEntity> findConfigByZone(Zone zone) {
        return this.bonusConfigRepo.findByZone(zone);
    }

    @Transactional
    public BonBasic1ConfigEntity saveConfig(BonBasic1ConfigEntity bonusConfig) {
        BonBasic1ConfigEntity persistentBonusConfig = (BonBasic1ConfigEntity)this.bonusConfigRepo.save((Object)bonusConfig);
        return persistentBonusConfig;
    }

    @Transactional(readOnly=true)
    public int countExceptionInBonus(BonBasic1ConfigEntity bonusConfig) {
        return this.bonusExceptionRepo.countByBonus(bonusConfig);
    }

    @Transactional
    public int deleteExceptions(BonBasic1ConfigEntity bonus) {
        return this.bonusExceptionRepo.deleteByBonus(bonus);
    }

    @Transactional
    public BonBasic1ExceptionEntity saveException(BonBasic1ExceptionEntity bonusException) {
        return (BonBasic1ExceptionEntity)this.bonusExceptionRepo.save((Object)bonusException);
    }
}

