/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.notification;

import de.rtb.pcon.core.notification.NotificationMessage;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class NotificationSenderThread<T extends NotificationMessage>
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(NotificationSenderThread.class);
    private static final Duration RECOVERY_TIME_OUT = Duration.ofMinutes(1L);
    private Throwable lastException;
    private LocalDateTime inRecoveryFrom;
    private BlockingQueue<T> queue;
    private Consumer<T> consumer;

    public NotificationSenderThread(String name, BlockingQueue<T> queue, Consumer<T> consumer) {
        super(name);
        this.setDaemon(true);
        this.queue = queue;
        this.consumer = consumer;
    }

    @Override
    public void run() {
        boolean active = true;
        NotificationMessage msg = null;
        while (active) {
            try {
                this.lastException = null;
                this.inRecoveryFrom = null;
                msg = (NotificationMessage)this.queue.take();
                if (msg.getType() != NotificationMessage.RecordTarget.SHUTDOWN_MARKER) {
                    this.consumer.accept(msg);
                    continue;
                }
                active = false;
            }
            catch (InterruptedException | RuntimeException e) {
                if (!this.queue.offer(msg)) {
                    log.error("Message for '{}' is lost. It cannot be put back to the queue. Queue is full {}.", (Object)msg.getReceiver(), (Object)this.queue.size());
                }
                log.error("Email was not sent. Next try in " + RECOVERY_TIME_OUT.toSeconds() + " seconds.", (Throwable)e);
                this.lastException = e;
                this.inRecoveryFrom = LocalDateTime.now();
                try {
                    NotificationSenderThread.sleep((long)RECOVERY_TIME_OUT.toMillis());
                }
                catch (InterruptedException e1) {
                    log.error("Mail thread can't sleep", (Throwable)e1);
                }
            }
            catch (Exception e) {
                this.lastException = e;
                log.error("Sender thread failed permanently. There will be no resume.", (Throwable)e);
                throw e;
            }
        }
    }

    public void shutDown() {
        NotificationMessage terminator = NotificationMessage.shutDown();
        this.queue.add(terminator);
    }

    public Throwable getLastEcException() {
        return this.lastException;
    }

    public Duration resumedIn() {
        if (this.inRecoveryFrom == null) {
            return Duration.ZERO;
        }
        return Duration.between(LocalDateTime.now(), this.inRecoveryFrom).plus(RECOVERY_TIME_OUT);
    }

    public boolean isOk() {
        return this.isAlive() && this.getLastEcException() == null;
    }

    public int numberOfMessagesInQueue() {
        return this.queue.size();
    }
}

