/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.core.integration.Crc16;
import de.rtb.pcon.core.integration.IntegrationConfig;
import de.rtb.pcon.core.integration.LanProps;
import de.rtb.pcon.core.integration.UpdMessageTask;
import de.rtb.pcon.core.services.pdm_in.ServerResponse;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

class UdpServer {
    private static final Logger log = LoggerFactory.getLogger(UdpServer.class);
    private MessageChannel errorChannel;
    private MessageChannel replyChannel;
    private LanProps lanProps;
    private DatagramSocket socket;
    private Thread socketReceiveThread;
    private byte[] receiveData = new byte[4096];
    @Autowired
    private IntegrationConfig.UdpInGateway gateway;
    @Autowired
    @Qualifier(value="mainTaskExecutor")
    private Executor mainExecutor;

    public UdpServer(MessageChannel replyChannel, MessageChannel errorChannel, LanProps lanProps) {
        this.lanProps = lanProps;
        this.errorChannel = errorChannel;
        this.replyChannel = replyChannel;
        try {
            this.socket = new DatagramSocket(lanProps.getUdpPort());
        }
        catch (SocketException e) {
            throw new IllegalStateException("Cannot start UDP server", e);
        }
    }

    @PostConstruct
    void start() {
        this.socketReceiveThread = new Thread(() -> this.reciveUdpPacket(), "udp-1");
        this.socketReceiveThread.setDaemon(true);
        this.socketReceiveThread.start();
        log.info("UDP server started on port {}.", (Object)this.lanProps.getUdpPort());
    }

    @PreDestroy
    void stop() {
        this.socket.close();
        this.socketReceiveThread.interrupt();
        log.info("UDP server has stopped.");
    }

    void reciveUdpPacket() {
        while (!this.socket.isClosed()) {
            try {
                DatagramPacket requestPacket = new DatagramPacket(this.receiveData, this.receiveData.length);
                this.socket.receive(requestPacket);
                byte[] dataFromPdm = Arrays.copyOf(this.receiveData, requestPacket.getLength());
                this.mainExecutor.execute((Runnable)new UpdMessageTask(dataFromPdm, requestPacket.getAddress(), requestPacket.getPort(), this.gateway, this.replyChannel, this.errorChannel));
            }
            catch (IOException e) {
                if (this.socketReceiveThread.isInterrupted()) continue;
                log.error("UDP socket exception.", ExceptionUtils.getRootCause((Throwable)e));
            }
            catch (RejectedExecutionException e) {
                log.debug("XXX Task rejected because of high load.");
            }
            catch (Exception e) {
                log.error("Exception in UDP thread.", ExceptionUtils.getRootCause((Throwable)e));
            }
        }
        log.info("Exiting UDP receiver thread");
    }

    public void sendUdpPacket(Message<?> responseMessage) {
        try {
            ServerResponse respose = (ServerResponse)responseMessage.getPayload();
            String netAddressStr = (String)responseMessage.getHeaders().get((Object)"ip_address", String.class);
            InetAddress netAddress = InetAddress.getByName(netAddressStr);
            Integer netPort = (Integer)responseMessage.getHeaders().get((Object)"ip_port");
            if (respose.contentType() == ServerResponse.ContentType.TEXT) {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                o.write(1);
                o.write(respose.toByteArray());
                o.write(3);
                byte[] payload = o.toByteArray();
                DatagramPacket responsePacket = new DatagramPacket(payload, payload.length);
                responsePacket.setAddress(netAddress);
                responsePacket.setPort(netPort);
                this.socket.send(responsePacket);
            } else {
                List transferBlocks = this.prepareTransferBlocks(respose);
                for (byte[] block : transferBlocks) {
                    DatagramPacket responsePacket = new DatagramPacket(block, block.length);
                    responsePacket.setAddress(netAddress);
                    responsePacket.setPort(netPort);
                    this.socket.send(responsePacket);
                }
                if (log.isDebugEnabled()) {
                    int firstBlockNumber = (Integer)respose.properties().get("first_block");
                    int lastBlockNumber = firstBlockNumber + transferBlocks.size() - 1;
                    log.debug("Data blocks {} - {} ({}) has been sent to {}:{}.", new Object[]{firstBlockNumber, lastBlockNumber, transferBlocks.size(), netAddress, netPort});
                }
            }
        }
        catch (IOException e) {
            log.error("Response to PDM was not sent", (Throwable)e);
        }
    }

    private List<byte[]> prepareTransferBlocks(ServerResponse r) throws IOException {
        byte[] data = r.toByteArray();
        Charset pdmCharset = StandardCharsets.ISO_8859_1;
        int pos = 0;
        int blockNumber = (Integer)r.properties().get("first_block");
        int blockSize = (Integer)r.properties().get("block_size");
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        while (pos < data.length) {
            ByteArrayOutputStream blckPayload = new ByteArrayOutputStream(blockSize + 20);
            blckPayload.write(String.format("PSA%05d;", (Integer)r.properties().get("pdm_number")).getBytes(pdmCharset));
            blckPayload.write(((String)r.properties().get("firmware_type")).getBytes(pdmCharset));
            blckPayload.write(String.format("%04d", blockNumber).getBytes(pdmCharset));
            int startOffset = pos;
            int endOffset = pos + blockSize;
            byte[] payload = Arrays.copyOfRange(data, startOffset, endOffset);
            if (endOffset > data.length) {
                int fillerStartIndex = blockSize - (endOffset - data.length);
                Arrays.fill(payload, fillerStartIndex, payload.length, (byte)-1);
            }
            blckPayload.write(payload);
            blckPayload.write(";".getBytes(pdmCharset));
            byte[] payloadWithHeader = blckPayload.toByteArray();
            ByteArrayOutputStream blckWrapper = new ByteArrayOutputStream(payloadWithHeader.length + 10);
            blckWrapper.write(1);
            blckWrapper.write(payloadWithHeader);
            String crc = Crc16.calculateCrcString((byte[])payloadWithHeader);
            blckWrapper.write(String.format("CRC%s", crc).getBytes(pdmCharset));
            blckWrapper.write(3);
            result.add(blckWrapper.toByteArray());
            pos = endOffset;
            ++blockNumber;
        }
        return result;
    }
}

