/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThreadPoolTaskExecutorLogMonitor {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolTaskExecutorLogMonitor.class);
    private static final String LOG_TEMPLATE = "iii: {}";
    private ThreadPoolTaskExecutor asm;
    private ThreadPoolTaskExecutor exe;
    private static final OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();

    public ThreadPoolTaskExecutor getAsm() {
        return this.asm;
    }

    public void setAsm(ThreadPoolTaskExecutor asm) {
        this.asm = asm;
    }

    public ThreadPoolTaskExecutor getExe() {
        return this.exe;
    }

    public void setExe(ThreadPoolTaskExecutor exe) {
        this.exe = exe;
    }

    public void logAsm() {
        if (log.isTraceEnabled() && ThreadPoolTaskExecutorLogMonitor.isQueueUsed((ThreadPoolTaskExecutor)this.getAsm())) {
            log.trace("iii: {}", (Object)ThreadPoolTaskExecutorLogMonitor.mkLogStr((ThreadPoolTaskExecutor)this.getAsm(), (String)"ASM"));
        }
    }

    public void logExe() {
        if (log.isTraceEnabled() && ThreadPoolTaskExecutorLogMonitor.isQueueUsed((ThreadPoolTaskExecutor)this.getExe())) {
            log.trace("iii: {}", (Object)ThreadPoolTaskExecutorLogMonitor.mkLogStr((ThreadPoolTaskExecutor)this.getExe(), (String)"EXE"));
        }
    }

    static String mkLogStr(ThreadPoolTaskExecutor te, String name) {
        StringBuilder result = new StringBuilder();
        result.append("Executor " + name + ":");
        if (te != null) {
            ThreadPoolExecutor ex = te.getThreadPoolExecutor();
            result.append(" Threads:");
            result.append(" active " + ex.getActiveCount());
            result.append(" (max " + ex.getLargestPoolSize() + ")");
            result.append(", pool ");
            result.append(ex.getPoolSize() + " / " + te.getMaxPoolSize());
            result.append(" , tasks " + ex.getCompletedTaskCount());
            if (ex.getQueue() != null) {
                BlockingQueue<Runnable> q = ex.getQueue();
                result.append("; Queue");
                int used = q.size();
                int free = q.remainingCapacity();
                result.append(" used " + used);
                result.append(", free " + free);
                result.append(", capacity " + (used + free));
            }
        } else {
            result.append(" N/A");
        }
        result.append(String.format("; CPU %.2f", osMXBean.getSystemLoadAverage()));
        int oneMB = 0x100000;
        MemoryUsage mem = memoryMXBean.getHeapMemoryUsage();
        result.append(String.format(", MEM %d/%d/%d MB", mem.getUsed() / (long)oneMB, mem.getCommitted() / (long)oneMB, mem.getMax() / (long)oneMB));
        return result.toString();
    }

    private static boolean isQueueUsed(ThreadPoolTaskExecutor te) {
        if (te != null && te.getThreadPoolExecutor().getQueue() != null) {
            int used = te.getThreadPoolExecutor().getQueue().size();
            return used > 1;
        }
        return false;
    }
}

