/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.core.integration.PdmMessageRawDto;
import de.rtb.pcon.core.services.pdm_in.MessageParserService;
import de.rtb.pcon.core.services.pdm_in.ServerResponse;
import java.time.Duration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

/*
 * Exception performing whole class analysis ignored.
 */
public class PdmRunnableTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PdmRunnableTask.class);
    private Message<PdmMessageRawDto> message;
    private MessageParserService messageParserService;

    public PdmRunnableTask(Message<PdmMessageRawDto> pdmMessage, MessageParserService messageParserService) {
        this.message = pdmMessage;
        this.messageParserService = messageParserService;
    }

    @Override
    public void run() {
        MessageChannel replyChannel;
        long execStartTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            Duration waitTime = this.getOldness();
            String msgText = (String)this.message.getHeaders().get((Object)"reqText");
            log.debug("@@@ [{}]: {}", (Object)PdmRunnableTask.formatTime((long)waitTime.toMillis()), (Object)msgText);
        }
        ServerResponse srvResponse = this.messageParserService.processMessage(this.message);
        Message msg = ((MessageBuilder)MessageBuilder.withPayload((Object)srvResponse).copyHeaders((Map)this.message.getHeaders())).build();
        long execTime = System.currentTimeMillis() - execStartTime;
        if (log.isInfoEnabled()) {
            log.info("<<< [{}]: {}", (Object)PdmRunnableTask.formatTime((long)execTime), (Object)srvResponse);
        }
        if ((replyChannel = (MessageChannel)this.message.getHeaders().getReplyChannel()) != null) {
            replyChannel.send(msg);
        } else {
            log.error("Cannot send response. Reply channel is not defined!");
        }
    }

    public Duration getOldness() {
        Long created = (Long)this.message.getHeaders().getOrDefault((Object)"received", (Object)0);
        long now = System.currentTimeMillis();
        return Duration.ofMillis(now - created);
    }

    private static String formatTime(long timeInMs) {
        return String.format("%3d", timeInMs);
    }
}

