/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import com.google.common.base.Joiner;
import de.rtb.pcon.config.CompatibilityProperties;
import de.rtb.pcon.core.integration.IntegrationConsts;
import de.rtb.pcon.core.integration.MessageFunctions;
import de.rtb.pcon.core.integration.PdmMessageProcessionException;
import de.rtb.pcon.core.services.pdm_in.ServerResponse;
import de.rtb.pcon.core.services.pdm_in.ServerResponseBuilder;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LoggingEventBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.integration.transformer.Transformer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.MessageBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class PdmMsgErrorTransformer
implements Transformer {
    private static final Logger log = LoggerFactory.getLogger(PdmMsgErrorTransformer.class);
    private static final Logger logRejected = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.rejected");
    private static final Pattern PSA_PATTERN = Pattern.compile("PSA(\\d+);");
    private static final Pattern GAC_PATTERN = Pattern.compile("GAC(\\d+);");
    public static final Pattern PDM_5 = Pattern.compile("VER *5\\.");
    @Autowired
    private CompatibilityProperties compatibilityProperties;

    public Message<?> transform(Message<?> inMsg) {
        ErrorMessage errorMessage = (ErrorMessage)inMsg;
        Throwable ex = (Throwable)errorMessage.getPayload();
        ServerResponseBuilder srb = new ServerResponseBuilder(IntegrationConsts.PDM_MESSAGE_ENCODING);
        Optional<Object> pdmRequest = Optional.empty();
        if (ex instanceof MessagingException) {
            MessagingException messagingEx = (MessagingException)ex;
            pdmRequest = Optional.ofNullable(messagingEx.getFailedMessage()).map(m -> (String)m.getHeaders().get((Object)"reqText", String.class));
            Throwable throwable = messagingEx.getCause();
            if (throwable instanceof PdmMessageProcessionException) {
                PdmMessageProcessionException e = (PdmMessageProcessionException)throwable;
                srb.append(e.getResponseMap());
            } else {
                Throwable mse = NestedExceptionUtils.getMostSpecificCause((Throwable)ex);
                String exMsg = "";
                exMsg = StringUtils.isBlank((CharSequence)mse.getMessage()) ? "(empty)" : mse.getMessage();
                String errorMsg = mse.getClass().getSimpleName() + ": " + exMsg;
                String pdmErrorMsg = MessageFunctions.formatErrorMessageForPdmMnemonic((String)errorMsg);
                srb.append("ERM", pdmErrorMsg);
            }
            PdmMsgErrorTransformer.findRegexMnemonicInt((Pattern)PSA_PATTERN, pdmRequest).ifPresent(p -> srb.append("PSA", p.intValue()));
            PdmMsgErrorTransformer.findRegexMnemonicInt((Pattern)GAC_PATTERN, pdmRequest).ifPresent(g -> srb.append("GAC", g.intValue()));
        } else {
            String errorMsg = NestedExceptionUtils.getMostSpecificCause((Throwable)ex).getMessage();
            String pdmErrorMsg = MessageFunctions.formatErrorMessageForPdmMnemonic((String)errorMsg);
            srb.append("ERM", pdmErrorMsg);
        }
        pdmRequest.ifPresent(r -> this.logRejectedMessage(r, ex));
        ServerResponse serverResponse = srb.build();
        log.error("<<< : {}", (Object)serverResponse);
        return MessageBuilder.withPayload((Object)serverResponse).copyHeaders((Map)errorMessage.getHeaders()).build();
    }

    private void logRejectedMessage(String pdmRequest, Throwable th) {
        LoggingEventBuilder logMain = log.atError();
        if (this.compatibilityProperties.isMutePdm5Error() && PDM_5.matcher(pdmRequest).find()) {
            logMain = log.atDebug();
        }
        logMain.setMessage("Failed to process message '{}'.\n{}").addArgument((Object)pdmRequest).addArgument((Object)PdmMsgErrorTransformer.filterRtbFrames((Throwable)th)).log();
        logRejected.error(pdmRequest);
        logRejected.atInfo().setMessage("Cause: {}").addArgument((Object)NestedExceptionUtils.getMostSpecificCause((Throwable)th).getMessage()).log();
        logRejected.atDebug().setMessage("StackTrace:\n{}").addArgument((Object)PdmMsgErrorTransformer.filterRtbFrames((Throwable)th)).log();
    }

    public static String filterRtbFrames(Throwable ex) {
        String[] frames = ExceptionUtils.getStackFrames((Throwable)ex);
        int nrOfSkippedFrames = 0;
        LinkedList<Object> result = new LinkedList<Object>();
        for (int i = 0; i < frames.length; ++i) {
            String frame = frames[i];
            if (!frame.startsWith("\t") || frame.trim().startsWith("at de.rtb")) {
                if (nrOfSkippedFrames > 0) {
                    result.add("\t ... skipped " + nrOfSkippedFrames + " frames ... ");
                }
                result.add(frame);
                nrOfSkippedFrames = 0;
                continue;
            }
            ++nrOfSkippedFrames;
        }
        if (nrOfSkippedFrames > 0) {
            result.add("\t ... skipped " + nrOfSkippedFrames + " frames ... ");
        }
        return Joiner.on((String)"\n").join(result);
    }

    static Optional<Integer> findRegexMnemonicInt(Pattern pat, Optional<String> text) {
        if (text.isEmpty()) {
            return Optional.empty();
        }
        Matcher m = pat.matcher(text.orElseThrow());
        if (m.find()) {
            return Optional.of(Integer.parseInt(m.group(1)));
        }
        return Optional.empty();
    }
}

