/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.integration.MessageFunctions;
import de.rtb.pcon.core.integration.PdmMessageRawDto;
import de.rtb.pcon.core.integration.PdmRunnableTask;
import de.rtb.pcon.core.integration.ThreadPoolTaskExecutorLogMonitor;
import de.rtb.pcon.core.services.pdm_in.MessageParserService;
import de.rtb.pcon.core.services.pdm_in.ServerResponseBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.stereotype.Service;

@Service
class PconEntryService {
    private static final Logger log = LoggerFactory.getLogger(PconEntryService.class);
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper pdmJsonMapper;
    @Autowired
    private MessageParserService messageParserService;
    @Autowired
    private ThreadPoolTaskExecutorLogMonitor tpMonitor;

    PconEntryService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(Message<?> msg) {
        Exception exception = null;
        try {
            Message<?> message = msg;
            this.tpMonitor.logAsm();
            this.tpMonitor.logExe();
            boolean isCrcOk = Optional.ofNullable((Boolean)message.getHeaders().get((Object)"crc_ok", Boolean.class)).orElse(Boolean.FALSE);
            if (isCrcOk) {
                PdmMessageRawDto pdmRequest = (PdmMessageRawDto)this.pdmJsonMapper.convertValue(message.getPayload(), PdmMessageRawDto.class);
                Message pdmRequestMessage = ((MessageBuilder)MessageBuilder.withPayload((Object)pdmRequest).copyHeaders((Map)message.getHeaders())).build();
                new PdmRunnableTask(pdmRequestMessage, this.messageParserService).run();
            } else {
                Map p = (Map)message.getPayload();
                ServerResponseBuilder nokBuilder = new ServerResponseBuilder(StandardCharsets.ISO_8859_1);
                nokBuilder.append("PSA", (String)p.get("PSA"));
                nokBuilder.append("GAC", (String)p.get("GAC"));
                nokBuilder.append("NOK");
                Message nokMsg = ((MessageBuilder)MessageBuilder.withPayload((Object)nokBuilder.build()).copyHeaders((Map)message.getHeaders())).build();
                MessageChannel replyChannel = (MessageChannel)message.getHeaders().getReplyChannel();
                if (replyChannel != null) {
                    replyChannel.send(nokMsg);
                } else {
                    log.error("Reply channel is not defined");
                }
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            MessageFunctions.clearThreadMetaData();
        }
        if (exception != null) {
            String protocol = (String)msg.getHeaders().get((Object)"src_protocol", String.class);
            if ("udp".equals(protocol)) {
                Optional messageChannel = Optional.ofNullable(msg.getHeaders()).flatMap(h -> Optional.ofNullable((MessageChannel)h.getErrorChannel()));
                if (messageChannel.isPresent()) {
                    MessageHandlingException msgException = new MessageHandlingException(msg, (Throwable)exception);
                    ErrorMessage emsg = new ErrorMessage((Throwable)msgException, msg.getHeaders(), msg);
                    ((MessageChannel)messageChannel.get()).send((Message)emsg);
                } else {
                    log.error("Cannot send error. Error channel is not defined!");
                }
            } else {
                throw new MessageHandlingException(msg, (Throwable)exception);
            }
        }
    }
}

