/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.config.DevelopmentProperties;
import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.integration.BlockingCallGuardPlatformThreadsService;
import de.rtb.pcon.core.integration.BlockingCallGuardVirtualThreadsService;
import de.rtb.pcon.core.integration.DataStreamSerializerTcp;
import de.rtb.pcon.core.integration.IntegrationConfig;
import de.rtb.pcon.core.integration.IntegrationConsts;
import de.rtb.pcon.core.integration.LanProps;
import de.rtb.pcon.core.integration.MessageFunctions;
import de.rtb.pcon.core.integration.PconEntryService;
import de.rtb.pcon.core.integration.PdmMsgErrorTransformer;
import de.rtb.pcon.core.integration.SlowDownRejectionPolicy;
import de.rtb.pcon.core.integration.ThreadPoolTaskExecutorLogMonitor;
import de.rtb.pcon.core.integration.UdpServer;
import de.rtb.pcon.core.services.pdm_in.ScalableResourcesConfigurationService;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.core.GenericTransformer;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.MessagingGatewaySpec;
import org.springframework.integration.handler.LoggingHandler;
import org.springframework.integration.ip.dsl.AbstractConnectionFactorySpec;
import org.springframework.integration.ip.dsl.Tcp;
import org.springframework.integration.ip.dsl.TcpInboundGatewaySpec;
import org.springframework.integration.ip.dsl.TcpNioServerConnectionFactorySpec;
import org.springframework.integration.util.CompositeExecutor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
class IntegrationConfig {
    public static final String TASK_EXECUTOR_TCP_ASSEMBLER = "tcpAsmTaskExecutor";
    public static final String TASK_EXECUTOR_MAIN = "mainTaskExecutor";
    private LanProps lanProps;

    public IntegrationConfig(LanProps lanProps) {
        this.lanProps = lanProps;
    }

    @Bean
    RejectedExecutionHandler abortPolicy() {
        return new ThreadPoolExecutor.AbortPolicy();
    }

    @Bean(value={"tcpAsmTaskExecutor"})
    Executor tcpAssemblerTaskExecutor(ScalableResourcesConfigurationService resCfg, DevelopmentProperties devProps) {
        if (devProps.isVirtualThreads()) {
            return new VirtualThreadTaskExecutor("asm-");
        }
        ThreadPoolTaskExecutor tasm = new ThreadPoolTaskExecutor();
        tasm.setThreadNamePrefix("asm-");
        tasm.setCorePoolSize(resCfg.tpAssemblerThreads);
        tasm.setMaxPoolSize(resCfg.tpAssemblerThreads);
        tasm.setQueueCapacity(resCfg.tpAssemblerQueue);
        tasm.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        this.taskExecutorMonitor().setAsm(tasm);
        tasm.initialize();
        return tasm;
    }

    @Bean(value={"mainTaskExecutor"})
    Executor mainTaskExecutor(ScalableResourcesConfigurationService resCfg, DevelopmentProperties devProps) {
        if (devProps.isVirtualThreads()) {
            return new VirtualThreadTaskExecutor("exe-");
        }
        ThreadPoolTaskExecutor exe = new ThreadPoolTaskExecutor();
        exe.setThreadNamePrefix("exe-");
        exe.setCorePoolSize(resCfg.tpMainThreads);
        exe.setMaxPoolSize(resCfg.tpMainThreads);
        exe.setQueueCapacity(resCfg.tpMainQueue);
        exe.setRejectedExecutionHandler((RejectedExecutionHandler)new SlowDownRejectionPolicy());
        this.taskExecutorMonitor().setExe(exe);
        exe.initialize();
        return exe;
    }

    @Bean
    ThreadPoolTaskExecutorLogMonitor taskExecutorMonitor() {
        return new ThreadPoolTaskExecutorLogMonitor();
    }

    @Bean
    BlockingCallGuard blockingCallGuard(ScalableResourcesConfigurationService resCfg, DevelopmentProperties devProps) {
        if (devProps.isVirtualThreads()) {
            return new BlockingCallGuardVirtualThreadsService();
        }
        return new BlockingCallGuardPlatformThreadsService(resCfg);
    }

    @Bean
    MessageChannel toProcessing() {
        return new PublishSubscribeChannel();
    }

    @Bean
    IntegrationFlow tcpServer(@Qualifier(value="tcpAsmTaskExecutor") Executor execAssembler, @Qualifier(value="mainTaskExecutor") Executor execMain) {
        DataStreamSerializerTcp tcpSerializer = new DataStreamSerializerTcp();
        TcpNioServerConnectionFactorySpec connectionFactory = (TcpNioServerConnectionFactorySpec)((TcpNioServerConnectionFactorySpec)((TcpNioServerConnectionFactorySpec)((TcpNioServerConnectionFactorySpec)Tcp.nioServer((int)this.lanProps.getTcpPort()).serializer((Serializer)tcpSerializer)).deserializer((Deserializer)tcpSerializer)).taskExecutor((Executor)new CompositeExecutor(execAssembler, execMain))).lookupHost(false);
        TcpInboundGatewaySpec tcpGateway = (TcpInboundGatewaySpec)((TcpInboundGatewaySpec)((TcpInboundGatewaySpec)Tcp.inboundGateway((AbstractConnectionFactorySpec)connectionFactory).replyTimeout(10000L)).requestTimeout(10000L)).errorChannel(this.errorChannel());
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessagingGatewaySpec)tcpGateway).enrichHeaders(Map.of("src_protocol", "tcp"))).channel(this.toProcessing())).get();
    }

    @Bean
    IntegrationFlow udpInlow() {
        return ((IntegrationFlowBuilder)IntegrationFlow.from(UdpInGateway.class).channel(this.udpInChannel())).get();
    }

    @Bean(value={"udpInChannel"})
    MessageChannel udpInChannel() {
        return new DirectChannel();
    }

    @Bean
    UdpServer udpServer() {
        return new UdpServer(this.udpReplayChannel(), this.errorChannel(), this.lanProps);
    }

    @Bean
    IntegrationFlow udpInFlow() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)this.udpInChannel()).enrichHeaders(h -> h.header("src_protocol", (Object)"udp"))).channel(this.toProcessing())).get();
    }

    @Bean
    IntegrationFlow intFlowPreProcessing(@Autowired PconEntryService pconService) {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)this.toProcessing()).enrich(e -> e.shouldClonePayload(false).headerFunction("received", m -> System.currentTimeMillis()).headerFunction("reqText", m -> new String((byte[])m.getPayload(), IntegrationConsts.PDM_MESSAGE_ENCODING)).headerFunction("crc_ok", m -> MessageFunctions.verifyCrc((byte[])((byte[])m.getPayload()))))).transform(Message.class, MessageFunctions::byteArrayToMap)).log(LoggingHandler.Level.INFO, IntegrationConfig.class.getName(), MessageFunctions::makeIncommingPacketLog)).handle(arg_0 -> ((PconEntryService)pconService).processMessage(arg_0))).get();
    }

    @Bean
    MessageChannel udpReplayChannel() {
        return new DirectChannel();
    }

    @Bean
    IntegrationFlow udpResponseFlow() {
        UdpServer udpServer = this.udpServer();
        return ((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)this.udpReplayChannel()).handle(arg_0 -> ((UdpServer)udpServer).sendUdpPacket(arg_0))).get();
    }

    @Bean
    MessageChannel errorChannel() {
        return new PublishSubscribeChannel();
    }

    @Bean
    IntegrationFlow errorFlow() {
        return ((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)this.errorChannel()).transform((GenericTransformer)new PdmMsgErrorTransformer())).get();
    }
}

