/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download;

import de.rtb.pcon.core.fw_download.DownloadRequestManager;
import de.rtb.pcon.core.fw_download.DownloadReservation;
import de.rtb.pcon.core.fw_download.TransferStatus;
import de.rtb.pcon.model.Pdm;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class DownloadRequestManagerPlatfromThreads
implements DownloadRequestManager {
    private int maxDownloads;
    private Duration downloadTimeout;
    private Clock clock;
    private Map<Integer, DownloadReservation> downloadRegister;

    public DownloadRequestManagerPlatfromThreads(int maxDownloads, Duration downloadTimeout) {
        this.downloadRegister = Collections.synchronizedMap(HashMap.newHashMap(maxDownloads));
        this.maxDownloads = maxDownloads;
        this.downloadTimeout = downloadTimeout;
        this.clock = Clock.systemUTC();
    }

    public boolean canDownloadStart() {
        this.cleanStaleEntries();
        return this.downloadRegister.size() < this.maxDownloads;
    }

    public int numberOfActiveDownloads() {
        return this.downloadRegister.size();
    }

    public void updateState(Pdm pdm, TransferStatus status) {
        if (status == TransferStatus.DONE) {
            this.downloadRegister.remove(pdm.getId());
            return;
        }
        DownloadReservation dr = this.downloadRegister.computeIfAbsent(pdm.getId(), k -> new DownloadReservation(pdm.getNumber().intValue(), pdm.getZone().getArea().getId().intValue(), LocalDateTime.now(this.clock)));
        dr.setStatus(status);
    }

    public int getMaxDownloads() {
        return this.maxDownloads;
    }

    private void cleanStaleEntries() {
        LocalDateTime now = LocalDateTime.now(this.clock);
        this.downloadRegister.entrySet().removeIf(e -> ((DownloadReservation)e.getValue()).getStatus().equals((Object)TransferStatus.DONE) || Duration.between(((DownloadReservation)e.getValue()).getUpdated(), now).compareTo(this.downloadTimeout) > 0);
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    Clock getClock() {
        return this.clock;
    }
}

