/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.config.security;

import de.rtb.pcon.config.DevelopmentProperties;
import de.rtb.pcon.config.security.HttpSecurityConfig;
import de.rtb.pcon.config.security.WanSecurityProps;
import de.rtb.pcon.model.UserRole;
import jakarta.servlet.Filter;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableMethodSecurity(prePostEnabled=true, jsr250Enabled=true)
@EnableWebSecurity
@Configuration
public class HttpSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpSecurityConfig.class);

    @Bean
    UserDetailsManager userDetailManager(PasswordEncoder passwordEncoder, DataSource dataSource) {
        JdbcUserDetailsManager udm = new JdbcUserDetailsManager(dataSource);
        udm.setDataSource(dataSource);
        udm.setUsersByUsernameQuery("select usa_login, usa_password, usa_enabled from control.user_authentication where usa_login=?");
        udm.setAuthoritiesByUsernameQuery("select usa_login, usr_role from control.user_authentication left join control.user_role on usa_id = usr_user_id where usa_login=?");
        return udm;
    }

    @Bean
    SecurityFilterChain web(HttpSecurity http, DevelopmentProperties devProps, WanSecurityProps wanProps) throws Exception {
        http.authorizeHttpRequests(a -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new String[]{"/", "/login", "/login.html", "/logout", "/logout.html", "/error", "/error.html"})).permitAll().requestMatchers(new String[]{"/file/download/job/**"})).authenticated().requestMatchers(new String[]{"/api/export/v1/**"})).hasAuthority(UserRole.ROLE_PCON_VIEW.name()).requestMatchers(new String[]{"/api/enforcement/v1/**"})).hasAnyAuthority(new String[]{UserRole.ROLE_ENFORCEMENT_VIEW.name()}).requestMatchers(new String[]{"/api/enforcement/aims2/**"})).hasAuthority(UserRole.ROLE_ENFORCEMENT_VIEW.name()).requestMatchers(new String[]{"/api/pcon/ui/**"})).hasAuthority(UserRole.ROLE_PCON_VIEW.name()).requestMatchers(new String[]{"/control/**"})).authenticated().requestMatchers(new String[]{"/swagger-ui.html", "/swagger-ui/**", "/api-docs/v3/**"})).hasAuthority(UserRole.ROLE_GENERAL_VIEW_API_DOC.name()).requestMatchers(new String[]{"/welcome.html"})).hasAuthority(UserRole.ROLE_PCON_VIEW.name());
            if (wanProps.isFreeActuators()) {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new String[]{"/actuator/**"})).permitAll();
            } else {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new String[]{"/actuator/**"})).hasAuthority(UserRole.ROLE_GENERAL_SERVER_MONITOR.name());
            }
        }).formLogin(fl -> ((FormLoginConfigurer)fl.loginProcessingUrl("/login")).loginPage("/login.html")).logout(logout -> Customizer.withDefaults()).httpBasic(Customizer.withDefaults());
        if (devProps.isDisableCsrf()) {
            http.csrf(c -> c.disable());
            log.warn("CSRF token is disabled. Do not use in production!");
        } else {
            CookieCsrfTokenRepository tokenRepository = CookieCsrfTokenRepository.withHttpOnlyFalse();
            CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
            http.csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)tokenRepository).csrfTokenRequestHandler((CsrfTokenRequestHandler)requestHandler).ignoringRequestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/api/pcon/ui/zones/*/bonus/disposable/codes/list")})).addFilterAfter((Filter)new CsrfCookieFilter(), BasicAuthenticationFilter.class);
        }
        return (SecurityFilterChain)http.build();
    }
}

