/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.v1.dao;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.api.enforcement.v1.dao.EnfMonetaryValueDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfPdmDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfPermitValidatedDao;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.TariffInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Optional;

@Schema(name="PermitFull", description="Parking permit (ticket)")
public class EnfPermitDao
extends EnfPermitValidatedDao {
    @Schema(description="Price payed for the permit.")
    private EnfMonetaryValueDao price;
    @Schema(description="PDM where the permit was issued.")
    private EnfPdmDao pdm;
    @Schema(description="Tariff name used for selling the permit.")
    @JsonProperty(value="tariff")
    private String tariffName;

    public EnfPermitDao(PaymentTransaction pt, ZoneId timeZone, Duration gracePeriod, boolean canViewLpn) {
        super(pt, timeZone, gracePeriod, canViewLpn);
        this.price = new EnfMonetaryValueDao(pt.getAmount(), pt.getCurrency());
        this.pdm = new EnfPdmDao(pt.getId().getPdm());
        this.tariffName = Optional.ofNullable(pt.getTariffInfo()).map(TariffInfo::getName).orElse(null);
    }

    public EnfMonetaryValueDao getPrice() {
        return this.price;
    }

    public EnfPdmDao getPdm() {
        return this.pdm;
    }

    public String getTariffName() {
        return this.tariffName;
    }
}

