/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.services;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.AreaRepository;
import de.rtb.pcon.repositories.UserRepository;
import de.rtb.pcon.repositories.ZoneRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SecurityService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AreaRepository areaRepo;
    @Autowired
    private ZoneRepository zoneRepo;
    @Autowired
    private PdmRepository pdmRepo;
    @Autowired
    private UserRepository userRepo;

    public Optional<UserDetails> getUserDetails() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!(auth instanceof AnonymousAuthenticationToken)) {
            return Optional.of((UserDetails)auth.getPrincipal());
        }
        return Optional.empty();
    }

    public String getCurrentUserLogin() {
        return this.getUserDetails().map(UserDetails::getUsername).orElse(null);
    }

    @Transactional(readOnly=true)
    public User getCurrentUser() {
        return this.getUserDetails().flatMap(u -> this.userRepo.findByLogin(u.getUsername())).orElse(null);
    }

    @Transactional
    public List<Area> getCurrentAreas() {
        return this.getCurrentAreas(this.getCurrentUser());
    }

    @Transactional
    public List<Area> getCurrentAreas(User user) {
        return this.areaRepo.forUserLogin(user.getLogin());
    }

    @Transactional
    public List<Pdm> getCurrentPdms() {
        return this.getUserDetails().map(UserDetails::getUsername).map(login -> this.pdmRepo.forUserLogin(login)).orElse(List.of());
    }

    @Transactional
    public List<Zone> getCurrentZones() {
        return this.getUserDetails().map(UserDetails::getUsername).map(login -> this.zoneRepo.forUserLogin(login)).orElse(List.of());
    }

    @Transactional
    public boolean hasMoreAreas() {
        return this.getCurrentAreas().stream().count() > 1L;
    }

    @Transactional
    public boolean hasRightFor(Pdm pdm) {
        return this.getCurrentPdms().stream().anyMatch(p -> Objects.equals(p.getId(), pdm.getId()));
    }

    @Transactional
    public boolean deniedFor(Pdm pdm) {
        return !this.hasRightFor(pdm);
    }

    @Transactional
    public boolean hasRightFor(Area area) {
        return this.getCurrentAreas().stream().anyMatch(a -> Objects.equals(a.getId(), area.getId()));
    }

    @Transactional
    public boolean deniedFor(Area area) {
        return !this.hasRightFor(area);
    }

    @Transactional
    public boolean hasRightFor(Zone zone) {
        return this.getCurrentZones().stream().anyMatch(p -> Objects.equals(p.getId(), zone.getId()));
    }

    @Transactional
    public boolean deniedFor(Zone zone) {
        return !this.hasRightFor(zone);
    }

    public boolean hasRole(String requiredRole) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!(auth instanceof AnonymousAuthenticationToken)) {
            UserDetails userDetail = (UserDetails)auth.getPrincipal();
            SimpleGrantedAuthority reqAuthority = new SimpleGrantedAuthority(requiredRole);
            return userDetail.getAuthorities().contains(reqAuthority);
        }
        return false;
    }

    public boolean hasRole(UserRole requiredRole) {
        return this.hasRole(requiredRole.toString());
    }
}

