/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.data_tables.export;

import de.rtb.pcon.core.notification.NotificationService;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.ui.data_tables.export.UserBackgroundJob;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;

@Service
public class BackgroundJobProcessorService
implements ServletContextAware,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(BackgroundJobProcessorService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private I18nService i18n;
    @Autowired
    @Qualifier(value="taskExecutorBackground")
    private Executor bgTaskExecutor;
    private ApplicationContext applicationContext;
    private File tempDir;
    public static final String JOB_OUTPUT_DIR = "job_results";

    @PostConstruct
    public void init() {
        logger.info("Background task processor initialized. Result directrory is '{}'.", (Object)this.tempDir);
        if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
            logger.debug("Non existing directory '{}' created.", (Object)this.tempDir);
        }
    }

    @PreDestroy
    public void shutdown() {
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void addJob(UserBackgroundJob job) {
        this.deleteOldDownloads();
        logger.atInfo().setMessage("Adding background task for {}.").addArgument(LoggerUtils.logUserArg((User)job.getRequester())).log();
        if (job.getRequester() == null) {
            logger.error("Task aborted because the requester is unknown.");
            return;
        }
        if (job.getRequester().getEmail() == null || job.getRequester().getEmail().isEmpty()) {
            logger.atError().setMessage("Task aborted because the e-mail address of {} is unknown.").addArgument(LoggerUtils.logUserArg((User)job.getRequester())).log();
            throw new RuntimeException(this.i18n.getLocalizedMessageWithLocale("core.jobs.ui.aborted.noemail", job.getLocale(), new Object[0]));
        }
        job.setEntityManager(this.entityManager);
        job.setOutLocation(this.tempDir);
        job.setApplicationContext(this.applicationContext);
        CompletableFuture.supplyAsync(job, this.bgTaskExecutor).whenComplete((result, exception) -> {
            if (exception == null) {
                this.onJobSuccess(job);
            } else {
                this.onJobFailure(job, exception);
            }
        });
    }

    public void setServletContext(ServletContext servletContext) {
        this.tempDir = (File)servletContext.getAttribute("jakarta.servlet.context.tempdir");
        this.tempDir = new File(this.tempDir, JOB_OUTPUT_DIR);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void deleteOldDownloads() {
        Date oldestAllowedFileDate = DateUtils.addDays((Date)new Date(), (int)-1);
        Iterator filesToDeleteIterator = FileUtils.iterateFiles((File)this.tempDir, (IOFileFilter)new AgeFileFilter(oldestAllowedFileDate), null);
        while (filesToDeleteIterator.hasNext()) {
            File fileToDelete = (File)filesToDeleteIterator.next();
            if (fileToDelete.isDirectory()) continue;
            if (!FileUtils.deleteQuietly((File)fileToDelete)) {
                try {
                    FileUtils.forceDeleteOnExit((File)fileToDelete);
                    logger.info("The temporary file '{}' can't be deleted. Scheduling deletion on VM exit.", (Object)fileToDelete.getAbsolutePath());
                }
                catch (IOException e) {
                    String msg = "Failed to schedule file '" + fileToDelete.getAbsolutePath() + "' deletion on VM exit.";
                    logger.error(msg, (Throwable)e);
                }
            }
            logger.debug("The temporary file '{}' has been deleted.", (Object)fileToDelete.getAbsolutePath());
        }
    }

    public void onJobSuccess(UserBackgroundJob task) {
        logger.info("Export task finished successfully");
        this.notificationService.sendExportJobDone(task.getOutLocation(), task.getRequester(), task.getLocale());
    }

    public void onJobFailure(UserBackgroundJob task, Throwable ex) {
        logger.error("Filed to process background task.", ex);
        this.notificationService.sendEmail(task.getRequester().getEmail(), this.i18n.getLocalizedMessageWithLocale("core.jobs.email.failed.subject", task.getLocale(), new Object[0]), this.i18n.getLocalizedMessageWithLocale("core.jobs.email.failed.body", task.getLocale(), new Object[]{ExceptionUtils.getStackTrace((Throwable)ex)}));
    }
}

