/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.data_tables.export;

import de.rtb.pcon.ui.data_tables.export.BackgroundJobProcessorService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class BackgroundJobController {
    @Autowired
    BackgroundJobProcessorService service;

    @GetMapping(value={"/file/download/job/{name}.{ext}"})
    public String downloadResult(@PathVariable(value="name") String jobName, @PathVariable(value="ext") String jobExt, HttpServletResponse response) throws IOException {
        String fileName = jobName + "." + jobExt;
        File requestedFile = new File(this.service.getTempDir(), fileName);
        if (!requestedFile.exists()) {
            return "redirect:/error.html";
        }
        switch (jobExt) {
            case "xlsx": {
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                response.setHeader("Date", ZonedDateTime.now(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME));
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            }
        }
        response.setContentLengthLong(requestedFile.length());
        Files.copy(requestedFile.toPath(), (OutputStream)response.getOutputStream());
        return null;
    }
}

