/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.bonus;

import de.rtb.pcon.core.gdpr.GdprService;
import de.rtb.pcon.core.services.pdm_in.MessageParserHelper;
import de.rtb.pcon.features.bonus.AppliedBonus;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.ui.controllers.reports.bonus.ReportBonusRepository;
import de.rtb.pcon.ui.controllers.reports.bonus.UiBonusHistoryRow;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.ExcelExportHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
@RequestMapping(path={"/api/pcon/ui/report/bonus"})
public class ReportBonusController {
    @Autowired
    private ReportBonusRepository reportBonusRepo;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private I18nService i18n;
    @Autowired
    private GdprService gdprService;

    private String normalizeLpnToEmptyString(String lpn) {
        return StringUtils.defaultString((String)MessageParserHelper.parseLcn((String)lpn));
    }

    @GetMapping(value={"history.json"})
    @Transactional(readOnly=true)
    public List<UiBonusHistoryRow> historyJson(@RequestParam(name="lpn", defaultValue="") String uiLpn, Authentication principal) {
        List areas = this.securityService.getCurrentAreas();
        OffsetDateTime timeSearchStart = OffsetDateTime.now().minusDays(60L).truncatedTo(ChronoUnit.DAYS);
        boolean isLpnProtected = this.gdprService.isLpnProtected();
        ZoneId timeZone = this.i18n.userTimeZoneId();
        List payments = this.gdprService.isLpnAllowed() ? this.reportBonusRepo.findPaymentWithBonuses(timeSearchStart, (Collection)areas, this.normalizeLpnToEmptyString(uiLpn)) : this.reportBonusRepo.findPaymentWithBonuses(timeSearchStart, (Collection)areas);
        return payments.stream().map(pt -> new UiBonusHistoryRow(pt, timeZone, isLpnProtected)).toList();
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"history.xlsx"})
    public void historyExcel(HttpServletResponse response, @RequestParam(name="lpn", defaultValue="") String uiLpn) throws IOException {
        List areas = this.securityService.getCurrentAreas();
        OffsetDateTime timeSearchStart = OffsetDateTime.now().minusDays(60L).truncatedTo(ChronoUnit.DAYS);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        List reportData = this.reportBonusRepo.findPaymentWithBonuses(timeSearchStart, (Collection)areas, this.normalizeLpnToEmptyString(uiLpn));
        Map<String, List<PaymentTransaction>> excelData = reportData.stream().collect(Collectors.groupingBy(PaymentTransaction::getCurrency));
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            XSSFCellStyle csDate = eeh.createDateTimeStyle(this.i18n.getLocalizedMessage("excel.format.datetime.short.minutes", new Object[0]));
            boolean isLpnProtected = this.gdprService.isLpnProtected();
            List orderedCurrencies = excelData.keySet().stream().sorted((s1, s2) -> ((List)excelData.get(s2)).size() - ((List)excelData.get(s1)).size()).toList();
            for (String currency : orderedCurrencies) {
                XSSFSheet sheet = eeh.addSheet(currency);
                eeh.addHeaderRow(new String[]{this.i18n.getLocalizedMessage("comp.table.header.label.gac", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.pdmNumber", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.pdmName", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.licensePlate", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.datePdm", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.parkEnd", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.payedTime", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.bonusTime", new Object[0])});
                for (PaymentTransaction pay : excelData.get(currency)) {
                    eeh.addRow();
                    eeh.addCell().setCellValue((double)pay.getId().getPdm().getNumber().intValue());
                    eeh.addCell().setCellValue(pay.getId().getPdm().getName());
                    eeh.addCell().setCellValue(pay.getId().getPdm().getZone().getArea().getName());
                    eeh.addCell().setCellValue(isLpnProtected ? "" : pay.getLpn());
                    eeh.addCell(csDate, pay.getServerTime().toZonedDateTime().withZoneSameInstant(timeZone).toLocalDateTime());
                    eeh.addCell(csDate, pay.getParkEndTime().toZonedDateTime().withZoneSameInstant(timeZone).toLocalDateTime());
                    eeh.addCell().setCellValue((double)Duration.between(pay.getId().getPdmTime(), pay.getParkEndTime()).toMinutes());
                    eeh.addCell().setCellValue((double)((AppliedBonus)pay.getBonus().get(0)).getDuration().toMinutes());
                }
                ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            }
            if (workbook.getNumberOfSheets() == 0) {
                workbook.createSheet(this.i18n.getLocalizedMessage("excel.emptySheetName", new Object[0]));
            }
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.bonus.history.export.filename", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }
}

