/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.model.zone.EnforcementMode;
import de.rtb.pcon.model.zone.Zone;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(name="Zone", description="A holder for multiple PDMs typically in the same geographical region (town, quarter, ...).")
public class UiZone2 {
    @Schema(name="Id of the zone.")
    private Integer id;
    @Schema(name="Name of the zone.")
    private String name;
    @Schema(name="Description of the zone.")
    private String description;
    @Schema(name="A color which user assigned to his zone. It is in HTML format #XXXXXX.")
    private String color;
    @Schema(name="Id of owning area.")
    private Integer area;
    @Schema(name="Allowed enforcement mode.")
    @JsonProperty(value="enfMode")
    private EnforcementMode enforcementMode;
    @Schema(name="Default zone.")
    @JsonProperty(value="def")
    private Boolean defaultZone;

    public UiZone2(Zone z) {
        this.id = z.getId();
        this.name = z.getName();
        this.description = z.getDescription();
        this.color = z.getColor();
        this.enforcementMode = z.getEnforcementMode();
        this.area = z.getArea().getId();
        this.defaultZone = z.getIsDefaultZone();
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getColor() {
        return this.color;
    }

    public EnforcementMode getEnforcementMode() {
        return this.enforcementMode;
    }

    public Integer getArea() {
        return this.area;
    }

    public Boolean getDefaultZone() {
        return this.defaultZone;
    }
}

