/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.rtb.pcon.model.MessageConfigUser;
import de.rtb.pcon.model.PdmStatus;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.ui.controllers.model.UiStatusMessageConfig;
import de.rtb.pcon.ui.controllers.model.UiUser;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiStatusMessage
extends UiStatusMessageConfig {
    private LocalDateTime time;
    private String reason;
    private UiUser acquirer;

    public UiStatusMessage() {
    }

    public UiStatusMessage(PdmStatus pst, MessageConfigUser mcUsr, ZoneId userTimeZone) {
        super(pst.getStatusMessage().getMessageConfig(), mcUsr);
        this.time = DateTimeUtils.toLocalDateTime((OffsetDateTime)pst.getStatusMessage().getPdmTime(), (ZoneId)userTimeZone);
        this.reason = pst.getStatusMessage().getReason();
        this.acquirer = Optional.ofNullable(pst.getAcquirer()).map(UiUser::new).orElse(null);
    }

    public UiStatusMessage(StatusMessage sm, MessageConfigUser mcUsr, ZoneId userTimeZone) {
        super(sm.getMessageConfig(), mcUsr);
        this.time = DateTimeUtils.toLocalDateTime((OffsetDateTime)sm.getPdmTime(), (ZoneId)userTimeZone);
        this.reason = sm.getReason();
        this.acquirer = null;
    }

    public UiStatusMessage(PdmStatus pst, ZoneId userTimeZone) {
        super(pst.getStatusMessage().getMessageConfig(), null);
        this.time = DateTimeUtils.toLocalDateTime((OffsetDateTime)pst.getStatusMessage().getPdmTime(), (ZoneId)userTimeZone);
        this.reason = pst.getStatusMessage().getReason();
        this.acquirer = Optional.ofNullable(pst.getAcquirer()).map(UiUser::new).orElse(null);
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public String getReason() {
        return this.reason;
    }

    public UiUser getAcquirer() {
        return this.acquirer;
    }

    public void setAcquirer(UiUser acquirer) {
        this.acquirer = acquirer;
    }

    public void setTime(LocalDateTime time) {
        this.time = time;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}

