/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.ui.controllers.model.filter.FilterPdmInclusive;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class PdmFilterRepository {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SecurityService securityService;

    @Transactional
    public List<Integer> findPdmsByInclusiveFilter(FilterPdmInclusive filter) {
        List allowedAreas = this.securityService.getCurrentAreas();
        if (CollectionUtils.isEmpty((Collection)allowedAreas)) {
            return Collections.emptyList();
        }
        CriteriaBuilder cqBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery cqQuery = cqBuilder.createQuery(Integer.class);
        Root cqPdm = cqQuery.from(Pdm.class);
        cqQuery.select((Selection)cqPdm.get("id"));
        cqPdm.join("zone");
        Predicate where = cqPdm.get("zone").get("area").in((Collection)allowedAreas);
        if (filter != null && (CollectionUtils.isNotEmpty((Collection)filter.getAreaIds()) || CollectionUtils.isNotEmpty((Collection)filter.getZoneIds()) || CollectionUtils.isNotEmpty((Collection)filter.getPdmIds()))) {
            Predicate locationFilter = cqBuilder.disjunction();
            if (CollectionUtils.isNotEmpty((Collection)filter.getAreaIds())) {
                locationFilter = cqBuilder.or((Expression)locationFilter, (Expression)cqPdm.get("zone").get("area").get("id").in(filter.getAreaIds()));
            }
            if (CollectionUtils.isNotEmpty((Collection)filter.getZoneIds())) {
                locationFilter = cqBuilder.or((Expression)locationFilter, (Expression)cqPdm.get("zone").get("id").in(filter.getZoneIds()));
            }
            if (CollectionUtils.isNotEmpty((Collection)filter.getPdmIds())) {
                locationFilter = cqBuilder.or((Expression)locationFilter, (Expression)cqPdm.get("id").in(filter.getPdmIds()));
            }
            where = cqBuilder.and((Expression)where, (Expression)locationFilter);
        }
        cqQuery.where((Expression)where);
        List filteredPdms = this.entityManager.createQuery(cqQuery).getResultList();
        if (filteredPdms.isEmpty()) {
            return List.of();
        }
        return filteredPdms;
    }

    @Transactional
    public List<Pdm> findBySelector(String selector, User user) {
        String[] selectorTokens;
        LinkedList<Integer> areas = new LinkedList<Integer>();
        LinkedList<Integer> zones = new LinkedList<Integer>();
        LinkedList<Integer> pdms = new LinkedList<Integer>();
        LinkedList<Integer> unassignedInAreas = new LinkedList<Integer>();
        LinkedList<Integer> unselectedPmds = new LinkedList<Integer>();
        for (String token : selectorTokens = StringUtils.split((String)selector, (char)',')) {
            if (StringUtils.startsWith((CharSequence)token, (CharSequence)"a")) {
                areas.add(Integer.parseInt(token.substring(1)));
                continue;
            }
            if (StringUtils.startsWith((CharSequence)token, (CharSequence)"z")) {
                zones.add(Integer.parseInt(token.substring(1)));
                continue;
            }
            if (StringUtils.startsWith((CharSequence)token, (CharSequence)"u")) {
                unassignedInAreas.add(Integer.parseInt(token.substring(1)));
                continue;
            }
            if (!NumberUtils.isCreatable((String)token)) continue;
            int pdmId = Integer.parseInt(token);
            if (pdmId > 0) {
                pdms.add(pdmId);
                continue;
            }
            unselectedPmds.add(pdmId * -1);
        }
        List allowedAreas = this.securityService.getCurrentAreas(user);
        CriteriaBuilder cqBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery cqQuery = cqBuilder.createQuery(Pdm.class);
        Root cqPdm = cqQuery.from(Pdm.class);
        Predicate where = cqPdm.get("zone").get("area").in((Collection)allowedAreas);
        Predicate inclusionPredicate = cqBuilder.disjunction();
        boolean isInclusionPredicateUsed = false;
        if (CollectionUtils.isNotEmpty(areas)) {
            inclusionPredicate = cqBuilder.or((Expression)inclusionPredicate, (Expression)cqPdm.get("zone").get("area").get("id").in(areas));
            isInclusionPredicateUsed = true;
        }
        if (CollectionUtils.isNotEmpty(zones)) {
            inclusionPredicate = cqBuilder.or((Expression)inclusionPredicate, (Expression)cqPdm.get("zone").get("id").in(zones));
            isInclusionPredicateUsed = true;
        }
        if (CollectionUtils.isNotEmpty(pdms)) {
            inclusionPredicate = cqBuilder.or((Expression)inclusionPredicate, (Expression)cqPdm.get("id").in(pdms));
            isInclusionPredicateUsed = true;
        }
        if (CollectionUtils.isNotEmpty(unassignedInAreas)) {
            inclusionPredicate = cqBuilder.or((Expression)inclusionPredicate, (Expression)cqBuilder.and((Expression)cqPdm.get("area").get("id").in(unassignedInAreas), (Expression)cqPdm.get("zone").isNull()));
            isInclusionPredicateUsed = true;
        }
        if (isInclusionPredicateUsed) {
            where = cqBuilder.and((Expression)where, (Expression)inclusionPredicate);
        }
        if (CollectionUtils.isNotEmpty(unselectedPmds)) {
            where = cqBuilder.and((Expression)where, (Expression)cqBuilder.not((Expression)cqPdm.get("id").in(unselectedPmds)));
        }
        cqQuery.where((Expression)where);
        return this.entityManager.createQuery(cqQuery).getResultList();
    }

    @Transactional
    public List<Pdm> findBySelector(String selector) {
        return this.findBySelector(selector, this.securityService.getCurrentUser());
    }
}

