/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model.download;

import de.rtb.pcon.model.EnumIndexOutOfBoundsException;
import de.rtb.pcon.model.PdmHwDevicePart;
import de.rtb.pcon.model.download.DeviceType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public enum DownloadTarget {
    CONFIG(1, DeviceType.PDM_CONFIG),
    PDM(2, DeviceType.PDM_FW),
    MODEM(3, DeviceType.MODEM),
    PRINTER_1(4, DeviceType.PRINTER),
    PRINTER_2(5, DeviceType.PRINTER),
    CARD_READER_1(6, DeviceType.CARD_READER),
    CARD_READER_2(7, DeviceType.CARD_READER),
    COIN_SELECTOR_FW(8, null),
    COIN_SELECTOR_DATA(9, DeviceType.COIN_SELECTOR),
    BNA(10, null),
    DISPLAY(11, DeviceType.DISPLAY);

    private static final Logger log;
    private int uty;
    private DeviceType deviceType;

    private DownloadTarget(int uty, DeviceType wiw) {
        this.uty = uty;
        this.deviceType = wiw;
    }

    public int uty() {
        return this.uty;
    }

    public DeviceType deviceType() {
        if (this.deviceType == null) {
            log.error("Device for target {} is not defined", (Object)this);
        }
        return this.deviceType;
    }

    public static DownloadTarget fromOrdinal(int ordinal) {
        return DownloadTarget.values()[ordinal];
    }

    public static DownloadTarget fromUty(int value) {
        for (DownloadTarget e : DownloadTarget.values()) {
            if (value != e.uty()) continue;
            return e;
        }
        throw new EnumIndexOutOfBoundsException(value, DownloadTarget.class);
    }

    public static Optional<DownloadTarget> formHwReport(String deviceName, PdmHwDevicePart part) {
        if (PdmHwDevicePart.CONFIG.equals((Object)part)) {
            switch (deviceName.toLowerCase()) {
                case "pdm": {
                    return Optional.of(CONFIG);
                }
                case "coin_selector": {
                    return Optional.of(COIN_SELECTOR_DATA);
                }
            }
            return Optional.empty();
        }
        if (PdmHwDevicePart.DEVICE.equals((Object)part)) {
            switch (deviceName.toLowerCase()) {
                case "pdm": {
                    return Optional.of(PDM);
                }
                case "modem": {
                    return Optional.of(MODEM);
                }
                case "printer_1": {
                    return Optional.of(PRINTER_1);
                }
                case "printer_2": {
                    return Optional.of(PRINTER_2);
                }
                case "card_reader_1": {
                    return Optional.of(CARD_READER_1);
                }
                case "card_reader_2": {
                    return Optional.of(CARD_READER_2);
                }
                case "coin_selector": {
                    return Optional.of(COIN_SELECTOR_FW);
                }
                case "bna": {
                    return Optional.of(BNA);
                }
                case "display": {
                    return Optional.of(DISPLAY);
                }
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    static {
        log = LoggerFactory.getLogger(DownloadTarget.class);
    }
}

