/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoConfigZone;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.features.partners.rao.model.ArticleIndexFilter;
import de.rtb.pcon.features.partners.rao.model.RaoArticle;
import de.rtb.pcon.features.partners.rao.model.RaoArticleIndexCompanyPdm;
import de.rtb.pcon.features.partners.rao.model.RaoArticleIndexResponsePdm;
import de.rtb.pcon.features.partners.rao.model.RaoArticlesMultipleCompaniesResponse;
import de.rtb.pcon.features.partners.rao.model.RaoCompany;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrArticleIndexOld
implements RealTimeRequest {
    private final RestClient restClient;
    private final BlockingCallGuard blokcingCallGuard;
    private final RaoConfigService raoConfigService;
    private final RaoProperties raoProps;

    RaoRtrArticleIndexOld(@Qualifier(value="wc3rdPartyApi") RestClient restClient, BlockingCallGuard blokcingCallGuard, RaoConfigService raoConfigService, RaoProperties raoProps) {
        this.restClient = restClient;
        this.blokcingCallGuard = blokcingCallGuard;
        this.raoConfigService = raoConfigService;
        this.raoProps = raoProps;
    }

    public int getId() {
        return 53;
    }

    public String getDescription() {
        return "RAO, article index (OLD)";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        return this.blokcingCallGuard.webCallExecute(() -> this.doWebCall(ctx));
    }

    private Map<String, Object> doWebCall(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        RaoConfigDto config = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        Optional filter = ctx.getLocalObjectO("filter", ArticleIndexFilter.class);
        try {
            RaoConfigDto raoCfg = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
            Integer zoneId = ctx.findPdmEntity().getZone().getId();
            RaoConfigZone zoneCfg = raoCfg.zones().stream().filter(z -> Objects.equals(z.rtbId(), zoneId)).findAny().orElseThrow(() -> new NoSuchElementException("PDM's zone does not exit in RAO configuration."));
            String raoZoneIdKey = filter.map(ArticleIndexFilter::property).or(() -> Optional.ofNullable(raoCfg.zoneIdProperty()).filter(StringUtils::isNotBlank)).orElse("ZONENAME");
            String raoZoneIdValue = filter.map(ArticleIndexFilter::value).orElse(zoneCfg.raoId());
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"api", "rao", "articles"}).queryParam("zoneKey", new Object[]{raoZoneIdKey}).queryParam("zone", new Object[]{raoZoneIdValue});
            if ("name".equalsIgnoreCase(raoCfg.townProperty())) {
                uriBuilder.queryParam("townKey", new Object[]{"NAME"});
                uriBuilder.queryParam("town", new Object[]{raoCfg.townValue()});
            }
            if ("id".equalsIgnoreCase(raoCfg.townProperty())) {
                uriBuilder.queryParam("townKey", new Object[]{"ID"});
                uriBuilder.queryParam("town", new Object[]{raoCfg.townValue()});
            }
            URI uri = uriBuilder.encode().build().toUri();
            RaoArticlesMultipleCompaniesResponse articleResponse = (RaoArticlesMultipleCompaniesResponse)this.restClient.get().uri(uri).retrieve().body(RaoArticlesMultipleCompaniesResponse.class);
            LinkedList<RaoArticleIndexCompanyPdm> companiesWitArticleIds = new LinkedList<RaoArticleIndexCompanyPdm>();
            if (articleResponse != null && articleResponse.companies() != null) {
                for (RaoCompany comp : articleResponse.companies()) {
                    List<String> articleIds = comp.articles().stream().map(RaoArticle::id).toList();
                    companiesWitArticleIds.add(new RaoArticleIndexCompanyPdm(comp.id(), comp.name(), articleIds));
                }
            }
            return Map.of("httpStatus", 200, "body", new RaoArticleIndexResponsePdm(articleResponse.status(), articleResponse.error(), companiesWitArticleIds));
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (ResourceAccessException e) {
            return Map.of("ERC", 3, "ERM", "Cannot access Applejack API.");
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

