/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.hks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.hks.HksConfigDto;
import de.rtb.pcon.features.partners.hks.HksConfigService;
import de.rtb.pcon.features.partners.hks.HksRtrCancelReceipt;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class HksRtrCancelReceipt
implements RealTimeRequest {
    @Autowired
    private BlockingCallGuard blokcingCallGuard;
    @Autowired
    private HksConfigService hksConfigService;
    @Autowired
    private RestClient restClient;

    HksRtrCancelReceipt() {
    }

    public int getId() {
        return 40;
    }

    public String getDescription() {
        return "HKS, cancel receipt";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        return this.blokcingCallGuard.webCallExecute(() -> this.doWebCall(ctx));
    }

    private Map<String, Object> doWebCall(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        HksConfigDto config = (HksConfigDto)this.hksConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        DtoHksReqCancel cancelReq = (DtoHksReqCancel)ctx.getLocalObject(DtoHksReqCancel.class);
        try {
            String cancelStr = new ObjectMapper().writeValueAsString((Object)cancelReq);
            URI cancelUri = UriComponentsBuilder.fromUriString((String)config.baseUrl()).pathSegment(new String[]{"pos", "cancellation", "receipt"}).build().toUri();
            String auth = "Basic " + HttpHeaders.encodeBasicAuth((String)config.user(), (String)config.password(), (Charset)StandardCharsets.UTF_8);
            ResponseEntity responseEntity = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(cancelUri)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON})).header("Authorization", new String[]{auth})).body((Object)cancelStr).retrieve().toEntity(DtoHksRespCancel.class);
            return Map.of("httpStatus", responseEntity.getStatusCode().value(), "body", responseEntity.getBody());
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
        catch (JsonProcessingException e) {
            return Map.of("ERC", 3, "ERM", e.getMessage());
        }
    }
}

