/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.allgau_card;

import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.PartnerUtils;
import de.rtb.pcon.features.partners.allgau_card.AwcConfigDto;
import de.rtb.pcon.features.partners.allgau_card.AwcConfigService;
import de.rtb.pcon.features.partners.allgau_card.AwcConfigZone;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaPartnerType;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{id}/partners/awc/"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class AwcController {
    private final AwcConfigService cfgService;
    private final SecureEntityLoaderService entityLoader;

    public AwcController(AwcConfigService cfgService, SecureEntityLoaderService entityLoader) {
        this.cfgService = cfgService;
        this.entityLoader = entityLoader;
    }

    @GetMapping(value={"config"})
    @Transactional(readOnly=true)
    public AwcConfigDto getConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        AwcConfigDto cfg = (AwcConfigDto)this.cfgService.fetchConfig(area);
        List uiZones = PartnerUtils.adjustZones((List)area.getZones(), (List)cfg.zones(), rtbId -> new AwcConfigZone(Integer.valueOf(rtbId), ""));
        return new AwcConfigDto(cfg.enabled(), cfg.apiKey(), cfg.vendorKey(), uiZones);
    }

    @PostMapping(value={"config"})
    @Transactional
    public void setConfig(@PathVariable int id, @RequestBody AwcConfigDto config) {
        Area area = this.entityLoader.loadArea(id);
        List<AwcConfigZone> zones = PartnerUtils.adjustZones((List)area.getZones(), (List)config.zones(), rtbId -> new AwcConfigZone(Integer.valueOf(rtbId), "")).stream().filter(z -> StringUtils.isNotEmpty((CharSequence)z.awcLocationId())).toList();
        AwcConfigDto newConfig = new AwcConfigDto(config.enabled(), config.apiKey(), config.vendorKey(), zones);
        this.cfgService.updateConfig(area, (PartnerConfiguration)newConfig);
    }

    @DeleteMapping(value={"config"})
    @Transactional
    public void deleteConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        this.cfgService.deleteConfig(area, AreaPartnerType.ALLGAU_CARD);
    }
}

