/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_2;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.features.bonus.multi_tariff_2.BonMt2RuleEntity;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;

class BonMt2RuleUi {
    private Integer id;
    private String lpn;
    private LocalDateTime from;
    private LocalDateTime to;
    private Integer renew;
    private String tariff;
    @JsonProperty(value="qr")
    private String qrCodeText;

    public BonMt2RuleUi() {
    }

    public BonMt2RuleUi(BonMt2RuleEntity rule, ZoneId userTimeZone, ZoneId pdmTimeZone) {
        this.id = rule.getId();
        this.lpn = rule.getLpn();
        this.from = DateTimeUtils.toLocalDateTime((OffsetDateTime)rule.getValidFrom(), (ZoneId)userTimeZone);
        this.to = DateTimeUtils.toLocalDateTime((OffsetDateTime)rule.getValidTo(), (ZoneId)userTimeZone);
        this.renew = rule.getExpiryToleranceInDays();
        this.tariff = rule.getTariffName();
        LocalDateTime pdmEnd = DateTimeUtils.toLocalDateTime((OffsetDateTime)rule.getValidTo(), (ZoneId)pdmTimeZone);
        this.qrCodeText = "RTB:41,{\"lpn\":\"%s\",\"exp\":\"%s\"}\n".formatted(rule.getLpn(), pdmEnd);
    }

    public Integer getId() {
        return this.id;
    }

    public String getLpn() {
        return this.lpn;
    }

    public LocalDateTime getFrom() {
        return this.from;
    }

    public LocalDateTime getTo() {
        return this.to;
    }

    public Integer getRenew() {
        return this.renew;
    }

    public String getTariff() {
        return this.tariff;
    }

    public String getQrCodeText() {
        return this.qrCodeText;
    }
}

