/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.card_id;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.rtb.pcon.features.bonus.card_id.BonIdRuleEntity;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
record BonIdBonusInfoDtoPdm(LocalDateTime expiration, Boolean expired, Integer usageMax, Integer usageCurrent, String type, String key) {
    private final LocalDateTime expiration;
    private final Boolean expired;
    private final Integer usageMax;
    private final Integer usageCurrent;
    private final String type;
    private final String key;

    BonIdBonusInfoDtoPdm(LocalDateTime expiration, Boolean expired, Integer usageMax, Integer usageCurrent, String type, String key) {
        this.expiration = expiration;
        this.expired = expired;
        this.usageMax = usageMax;
        this.usageCurrent = usageCurrent;
        this.type = type;
        this.key = key;
    }

    public static BonIdBonusInfoDtoPdm fromEntity(BonIdRuleEntity rule, ZoneId pdmTimeZone) {
        Optional<LocalDateTime> expirationO = Optional.ofNullable(rule.getExpiration()).map(exp -> exp.toZonedDateTime().withZoneSameInstant(pdmTimeZone).toLocalDateTime());
        return new BonIdBonusInfoDtoPdm((LocalDateTime)expirationO.orElse(null), (Boolean)expirationO.map(exp -> LocalDateTime.now().isAfter((ChronoLocalDateTime<?>)exp)).orElse(null), rule.getType().getMaxIssues(), rule.getUsedTimes(), rule.getType().getName(), rule.getKey());
    }

    public LocalDateTime expiration() {
        return this.expiration;
    }

    public Boolean expired() {
        return this.expired;
    }

    public Integer usageMax() {
        return this.usageMax;
    }

    public Integer usageCurrent() {
        return this.usageCurrent;
    }

    public String type() {
        return this.type;
    }

    public String key() {
        return this.key;
    }
}

